test_that("final_svyglm runs on synthetic data and returns OR table and AUC", {

  set.seed(123)
  n <- 800

  synthetic_svy <- data.frame(
    psu      = sample(1:80, n, replace = TRUE),
    strata   = sample(1:40, n, replace = TRUE),
    weight   = runif(n, 0.5, 3),
    exposure = rbinom(n, 1, 0.45),
    age      = round(rnorm(n, 50, 12)),
    sex      = factor(sample(c("Male", "Female"), n, replace = TRUE)),
    bmi      = round(rnorm(n, 27, 4), 1)
  )

  linpred <- -2 + 0.8 * synthetic_svy$exposure + 0.03 * synthetic_svy$age
  synthetic_svy$outcome <- rbinom(n, 1, plogis(linpred))

  fit_main <- final_svyglm(
    data = synthetic_svy,
    dep_var = "outcome",
    covariates = c("age", "sex", "bmi"),
    id_var = "psu",
    strata_var = "strata",
    weight_var = "weight",
    family = "binomial",
    level = 0.95,
    interaction_terms = NULL
  )

  ## ---- basic structure --------------------------------------------------
  expect_s3_class(fit_main, "svyCausal")
  expect_true(is.list(fit_main))

  ## ---- OR table ---------------------------------------------------------
  expect_true("OR_table" %in% names(fit_main))
  expect_s3_class(fit_main$OR_table, "data.frame")

  expect_true(
    all(c("OR", "CI_low", "CI_high") %in% colnames(fit_main$OR_table))
  )

  expect_true(all(fit_main$OR_table$OR > 0))

  ## ---- AUC --------------------------------------------------------------
  ## ---- predictions ------------------------------------------------------
  expect_true("predictions" %in% names(fit_main))
  expect_length(fit_main$predictions, n)
  ####
  expect_true(
    all(
      fit_main$OR_table$CI_low <= fit_main$OR_table$OR &
        fit_main$OR_table$OR <= fit_main$OR_table$CI_high
    )
  )
})
