% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz_auc_svyglm.R
\name{viz_auc_svyglm}
\alias{viz_auc_svyglm}
\title{Weighted ROC Curve for Survey-Weighted Models}
\usage{
viz_auc_svyglm(
  fit_object,
  title = "Weighted ROC Curve",
  line_color = "#0072B2"
)
}
\arguments{
\item{fit_object}{object obtain from logistic regression}

\item{title}{Character. Plot title.}

\item{line_color}{Character. ROC curve color.}
}
\value{
A ggplot object.
}
\description{
Produces a weighted ROC curve and reports weighted AUC
for survey-based models.
}
\details{
AUC is computed using, consistent with
complex survey weighting.
}
\examples{
set.seed(123)
n <- 100
dat <- data.frame(
  psu = sample(1:10, n, replace = TRUE),
  strata = sample(1:5, n, replace = TRUE),
  weight = runif(n, 0.5, 2),
  age = rnorm(n, 50, 10),
  sex = factor(sample(c("Male", "Female"), n, replace = TRUE)),
  exposure = rbinom(n, 1, 0.5)
)
dat$outcome <- rbinom(n, 1, plogis(-2 + 0.03*dat$age + 0.5*dat$exposure))
fit_example<-final_svyglm(dat, dep_var="outcome", covariates=c("age","sex"),
             id_var="psu", strata_var="strata", weight_var="weight")
viz_auc_svyglm(fit_object=fit_example)
}
