% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/final_svyglm.R
\name{final_svyglm}
\alias{final_svyglm}
\title{Final Survey-Weighted GLM}
\usage{
final_svyglm(
  data,
  dep_var,
  covariates,
  id_var,
  strata_var,
  weight_var,
  family = "binomial",
  level = 0.95,
  interaction_terms = NULL
)
}
\arguments{
\item{data}{A data frame containing the survey data.}

\item{dep_var}{Character. Name of the binary outcome variable (0/1).}

\item{covariates}{Character vector of covariate names to adjust for.}

\item{id_var}{Character. Name of the primary sampling unit variable.}

\item{strata_var}{Character. Name of the stratification variable.}

\item{weight_var}{Character. Name of the survey weight variable.}

\item{family}{Character. Currently supports only \code{"binomial"}.}

\item{level}{Numeric. Confidence level for intervals (default = 0.95).}

\item{interaction_terms}{Optional character vector of interaction terms.}
}
\value{
A list containing:
\itemize{
\item \code{model}: Survey-weighted logistic regression model.
\item \code{results_table}: Odds ratios with confidence intervals and p-values.
\item \code{AUC}: Survey-weighted AUC (Somers' C).
\item \code{data}: Input data with predicted probabilities.
\item \code{design}: Survey design object.
}
}
\description{
Fits a survey-weighted logistic regression model (quasibinomial) using raw survey variables.
Returns ORs, confidence intervals, p-values, and model discrimination statistics.
}
\examples{
set.seed(123)
n <- 100
dat <- data.frame(
  psu = sample(1:10, n, replace = TRUE),
  strata = sample(1:5, n, replace = TRUE),
  weight = runif(n, 0.5, 2),
  age = rnorm(n, 50, 10),
  sex = factor(sample(c("Male", "Female"), n, replace = TRUE)),
  exposure = rbinom(n, 1, 0.5)
)
dat$outcome <- rbinom(n, 1, plogis(-2 + 0.03*dat$age + 0.5*dat$exposure))
fit_simple<-final_svyglm(dat, dep_var="outcome", covariates=c("age","sex"),
             id_var="psu", strata_var="strata", weight_var="weight")
fit_simple$OR_table
}
