% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/final_prog_svyglm.R
\name{final_prog_svyglm}
\alias{final_prog_svyglm}
\title{Prognostic-weighted survey GLM
Prognostic-weighted survey GLM}
\usage{
final_prog_svyglm(
  data,
  dep_var,
  exposure,
  covariates,
  id_var,
  strata_var,
  weight_var,
  outcome_covariates = NULL,
  level = 0.95,
  ...
)
}
\arguments{
\item{data}{Data frame}

\item{dep_var}{Character; binary outcome}

\item{exposure}{Character; exposure variable}

\item{covariates}{Character vector; adjustment variables}

\item{id_var}{Character; PSU}

\item{strata_var}{Character; strata}

\item{weight_var}{Character; survey weight}

\item{outcome_covariates}{Character vector; optional covariates for final model}

\item{level}{Numeric; CI level}

\item{...}{Additional args to svyglm}
}
\value{
A list with:
\itemize{
\item \code{prog_model}: Prognostic svyglm.
\item \code{final_model}: Weighted outcome svyglm.
\item \code{OR_table}: Odds ratios with CI.
\item \code{AUC}: Weighted AUC.
\item \code{data}: Data with prognostic weights.
}
}
\description{
Fits a survey-weighted logistic regression model using stabilized
prognostic score weights derived from a model predicting the outcome
conditional on baseline covariates and excluding the exposure effect.
The function supports design-based inference under complex survey
sampling while adjusting for confounding through prognostic weighting
}
\examples{
set.seed(123)
n <- 1000
dat <- data.frame(
  psu = sample(1:10, n, replace = TRUE),
  strata = sample(1:5, n, replace = TRUE),
  weight = runif(n, 0.5, 2),
  age = rnorm(n, 50, 10),
  sex = factor(sample(c("Male", "Female"), n, replace = TRUE)),
  exposure = rbinom(n, 1, 0.5)
)
dat$outcome <- rbinom(n, 1, plogis(-2 + 0.03*dat$age + 0.5*dat$exposure))
fit<-final_prog_svyglm(data = dat,
 dep_var = "outcome",
 exposure="exposure",
 covariates = c("age", "sex"),
 id_var = "psu",
 strata_var = "strata",
 weight_var = "weight",
 level = 0.95
)
names(fit)
fit$OR_table
}
