% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvef.ph.R
\name{tvef.zero.time}
\alias{tvef.zero.time}
\title{testing the significance of the covariates from a \code{coxtv} or \code{coxtp} object using a Wald test statistic}
\usage{
tvef.zero.time(fit, time, parm)
}
\arguments{
\item{fit}{fitted \code{coxtv} or \code{coxtp}  model.}

\item{time}{the time points to test if the covariate is significant or not.}

\item{parm}{the names of parameters to be tested.}
}
\value{
\code{tvef.zero.time} produces a list of length \code{nvars}. Each element of the list is a matrix with respect to a
covariate. The matrix is of dimension \code{len_unique_t} by 4, where \code{len_unique_t} is the length of unique observed event time.
Each row corresponds to the testing result at that time.  The four
columns give the estimations, standard error, test-statistic and  P-value.
}
\description{
Testing the significance of the covariates at each time point.
}
\examples{
data(ExampleData)
z <- ExampleData$z
time  <- ExampleData$time
event <- ExampleData$event
fit   <- coxtv(event = event, z = z, time = time)
test  <- tvef.zero.time(fit)

}
\seealso{
\code{\link{tvef.ph}} \code{\link{tvef.zero}}
}
