% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_sunburst.R
\name{sunburstUI}
\alias{sunburstUI}
\alias{sunburstServer}
\title{Sunburst Shiny Module UI}
\usage{
sunburstUI(id)

sunburstServer(
  id,
  chartData,
  design,
  btn_font_size = "14px",
  show_colors_in_table = FALSE,
  steps_table_export_name = reactive(NULL),
  n_steps = reactive(5L)
)
}
\arguments{
\item{id}{A character string for the module namespace.}

\item{chartData}{A list containing chart data including event codes and
cohort pathways.}

\item{design}{A list containing design configuration for the sunburst plot.}

\item{btn_font_size}{A character string for action button font size.}

\item{show_colors_in_table}{Logical; if \code{TRUE}, show colored buttons in
the steps table.}

\item{steps_table_export_name}{A reactive returning a custom export filename,
or \code{NULL} for the default.}

\item{n_steps}{A reactive returning the number of pathway steps to display.}
}
\value{
A \code{tagList} containing the sunburst UI elements.

A Shiny module server function.
}
\description{
Sunburst Shiny Module UI

Sunburst Shiny Module Server
}
