#' @export
skeleton <- function(x, mapping=NULL) {

  if((!is.character(x))|length(x)>1){stop("The parameter x must be a character vector of length 1.")}

  if(is.null(mapping)){
    path  <- system.file("extdata", "etcsl_mapping.txt", package = "sumer")
    mapping <- read.csv2(path, sep=";", na.strings="")
  }

  x <- info(x)
  x <- paste0(c("", x$reading), attr(x,"separators"), collapse = "")

  "get_equation" <- function(x){
    x   <- info(x, mapping=mapping)
    res <- paste0(c(paste0(x$reading, collapse="-"),paste0(x$name, collapse="."), paste0(x$sign, collapse="")), collapse="=")
    return(res)
  }

  # Text normalisieren und in Wörter aufteilen
  words <- str_split_1(str_squish(x), " ")

  use <- rep(TRUE, length(words))
  for(i in 1:length(words)){
    if(str_detect(get_equation(words[i]), fixed("=="))){
      use[i]<-FALSE
    }
  }
  words <- words[use]

  n_words <- length(words)

  if(n_words==0){return("")}

  result <- character()

  # Gleichung für erstes Wort holen, um Silbenzahl zu prüfen
  first_eq <- get_equation(words[1])
  first_eq_parts <- str_split_1(first_eq, "=")
  first_syllables <- str_split_1(first_eq_parts[1], "-")

  # Fall bestimmen
  is_single_word <- (n_words == 1)
  is_single_syllable <- is_single_word && (length(first_syllables) == 1)

  # Hilfsfunktion: Silben eines Wortes verarbeiten
  process_syllables <- function(syllables_str, tab_syllable, tab_subsign) {
    syllables <- str_split_1(syllables_str, "-")
    lines <- character()

    # Nur Silben-Zeilen erzeugen wenn es mehr als eine Silbe gibt
    show_syllable_lines <- (length(syllables) > 1)

    for (syllable in syllables) {
      syl_eq <- get_equation(syllable)
      syl_eq_parts <- str_split_1(syl_eq, "=")
      syl_sign_names <- str_split_1(syl_eq_parts[2], "\\.")

      # Silben-Zeile nur wenn mehr als eine Silbe
      if (show_syllable_lines) {
        lines <- c(lines, paste0("|", tab_syllable, syl_eq, "::"))
      }

      # Unter-Zeichen, falls Silbe aus mehreren Zeichen besteht
      if (length(syl_sign_names) > 1) {
        # Tab-Ebene: wenn Silben-Zeile wegfällt, eine Ebene weniger
        actual_tab <- if (show_syllable_lines) tab_subsign else tab_syllable
        for (sign_name in syl_sign_names) {
          sign_eq <- get_equation(sign_name)
          lines <- c(lines, paste0("|", actual_tab, sign_eq, "::"))
        }
      }
    }
    return(lines)
  }

  if (is_single_syllable) {
    # Einzelne Silbe: keine Header, keine Tabs für Hauptzeile, 1 Tab für Unter-Zeichen
    eq_parts <- str_split_1(first_eq, "=")
    sign_names <- str_split_1(eq_parts[2], "\\.")

    result <- c(result, paste0("|", first_eq, "::"))

    if (length(sign_names) > 1) {
      for (sign_name in sign_names) {
        sign_eq <- get_equation(sign_name)
        result <- c(result, paste0("|\t", sign_eq, "::"))
      }
    }

  } else if (is_single_word) {
    # Einzelnes Wort (mehrere Silben): Wort-Gleichung als Header
    eq_parts <- str_split_1(first_eq, "=")
    syllables_str <- eq_parts[1]

    result <- c(result, paste0("|", first_eq, "::"))
    result <- c(result, process_syllables(syllables_str, "\t", "\t\t"))

  } else {
    # Mehrere Wörter: volle Struktur mit Header-Zeile
    result <- c(result, paste0("|", x, "::"))

    for (i in seq_along(words)) {
      word <- words[i]
      eq <- get_equation(word)
      eq_parts <- str_split_1(eq, "=")
      syllables_str <- eq_parts[1]

      # Wort-Zeile
      result <- c(result, paste0("|", eq, "::"))

      # Silben verarbeiten
      result <- c(result, process_syllables(syllables_str, "\t", "\t\t"))

      # Leerzeile nach jedem Wort
      result <- c(result, "")
    }
  }

  class(result) <- c("skeleton", "character")

  return(result)
}


#' @exportS3Method print skeleton
print.skeleton <- function(x, ...){
  cat(x, sep="\n")
}
