% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrr.R
\name{rrr}
\alias{rrr}
\title{Risk-Return Ratio}
\usage{
rrr(prices = NULL, gains = NULL)
}
\arguments{
\item{prices}{Numeric matrix with 1 column of prices for each investment (can 
be a vector if there is only one).}

\item{gains}{Numeric matrix with 1 column of gains for each investment (can 
be a vector if there is only one).}
}
\value{
Numeric value or vector.
}
\description{
Calculates risk-return ratio, defined as growth rate divided by maximum 
drawdown.
}
\examples{
# Simulate daily gains over a 5-year period
set.seed(123)
stock.gains <- rnorm(252 * 5, 0.0005, 0.01)

# Convert to daily balances assuming an initial balance of $10,000
daily.balances <- gains_prices(stock.gains + 1)

# Total return is about 1.23
daily.balances[length(daily.balances)] / daily.balances[1] - 1

# Maximum drawdown is about 0.19
mdd(prices = daily.balances)

# Ratio of these two is about 6.48
(daily.balances[length(daily.balances)] / daily.balances[1] - 1) / 
mdd(daily.balances)

# Easier to calculate using rrr function
rrr(daily.balances)


}
