% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gam.R
\name{plot_gam}
\alias{plot_gam}
\title{Plot GAM Model}
\usage{
plot_gam(
  model,
  predictor,
  quantile.others = 50,
  col = "blue4",
  bg = adjustcolor("dodgerblue", 0.2),
  plot2 = "auto",
  col2 = NULL,
  bg2 = "gray90",
  ...
)
}
\arguments{
\item{model}{A GAM model object fitted using \code{mgcv::gam()}.}

\item{predictor}{Character string specifying the name of the predictor variable
to plot on the x-axis.}

\item{quantile.others}{Number between 1 and 99 for quantile
at which all other predictors are held constant. Default is 50 (median).}

\item{col}{Color for the prediction line. Default is "blue4".}

\item{bg}{Background color for the confidence band. Default is
\code{adjustcolor('dodgerblue', .2)}.}

\item{plot2}{How to plot the distribution in the lower plot. Options: \code{'auto'} (default,
auto-select based on number of unique values), \code{'freq'} (always plot frequencies),
\code{'density'} (always plot the density) or \code{'none'} (neither). When \code{'auto'}, 
plots frequencies with predictor has less than 30 unique values, density otherwise.}

\item{col2}{Color for the lines/bars in the bottom distribution plot. Default is "dodgerblue"}

\item{bg2}{Background color for the bottom distribution plot. Default is "gray90".}

\item{...}{Additional arguments passed to \code{plot()} and \code{lines()}.}
}
\value{
Invisibly returns a list containing:
\itemize{
  \item \code{predictor_values}: The sequence of predictor values used
  \item \code{predicted}: The predicted values
  \item \code{se}: The standard errors
  \item \code{lower}: Lower confidence bound (predicted - 2*se)
  \item \code{upper}: Upper confidence bound (predicted + 2*se)
}
}
\description{
Plots fitted GAM values for focal predictor,
keeping any other predictors in the model at a specified quantile  (default: median)
}
\examples{
\donttest{
library(mgcv)
# Fit a GAM model
data(mtcars)
mtcars$cyl <- factor(mtcars$cyl)  # Convert to factor before fitting GAM
model <- gam(mpg ~ s(hp) + s(wt) + cyl, data = mtcars)

# Plot effect of hp (with other variables at median)
plot_gam(model, "hp")

# Plot effect of hp (with other variables at 25th percentile)
plot_gam(model, "hp", quantile.others = 25)

# Customize plot
plot_gam(model, "hp", main = "Effect of Horsepower", col = "blue", lwd = 2)
}

}
