% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{link_function}
\alias{link_function}
\title{Link function}
\usage{
link_function(mu, family)
}
\arguments{
\item{mu}{numeric vector (with values in unit interval if family="binomial")}

\item{family}{character \code{"gaussian"} or \code{"binomial"}}
}
\value{
Returns a numeric vector of the transformed values.
}
\description{
Applies the link function.
}
\examples{
family <- "binomial"
from <- ifelse(family=="binomial",0,-3)
to <- ifelse(family=="binomial",1,3)
mu <- seq(from=from,to=to,length.out=100)
eta <- link_function(mu=mu,family=family)
graphics::plot(x=mu,y=eta,type="l",main=family)
v <- ifelse(family=="binomial",0.5,0)
graphics::abline(v=v,lty=2)
graphics::abline(h=0,lty=2)

}
\keyword{internal}
