% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{construct_penfacs}
\alias{construct_penfacs}
\title{Construct penalty factors}
\usage{
construct_penfacs(w_int, w_ext, v_int, v_ext, type)
}
\arguments{
\item{w_int}{internal weights:
numeric vector of length \eqn{p} with non-negative entries}

\item{w_ext}{external weights:
numeric vector of length \eqn{p} with non-negative entries}

\item{v_int}{exponent or factor for internal weights:
non-negative scalar}

\item{v_ext}{exponent or factor for external weights:
non-negative scalar}

\item{type}{scaling of weights:
character \code{"exp"}, \code{"ari"}, \code{"geo"}, or \code{"rem"}
(with or without addition of \code{".con"}),
default: \code{"exp"}}
}
\value{
Returns a vector of length \eqn{q} (non-negative entries).
}
\description{
Uses internal and external weights
as well as internal and external exponents or factors for these weights
to construct penalty factors.
}
\details{
While internal weights are from the problem of interest ("supported" problem),
external weights are from the other problems ("supporting" problems).

Multiple options exist for scaling prior weights:
\itemize{
\item \code{"exp"}: \eqn{w_{int}^{v_{int}}+w_{ext}^{v_{ext}}}
\item \code{"ari"}: \eqn{v_{int} w_{int} + v_{ext} w_{ext}}
\item \code{"geo"}: \eqn{w_{int}^{v_{int}} w_{ext}^{v_{ext}}}
\item \code{"rem"}: \eqn{w_{int}^{v_{int}}+w_{ext}^{v_{ext}}-\mathbb{I}(v_{int}=0)-\mathbb{I}(v_{ext}=0))}
}
The constrained versions \code{"exp.con"}, \code{"ari.con"},
\code{"geo.con"}, and \code{"rem.con"} impose \eqn{v_{int}+v_{ext}=1}.
The penalty factors are the inverse weights.
Suggested choices are \code{"exp"} for predictivity
and \code{"ari.con"} for interpretability.
}
\examples{
n <- 10
w_int <- stats::runif(n)
w_ext <- stats::runif(n)
construct_penfacs(w_int,w_ext,v_int=0.5,v_ext=0.5,type="exp")

}
\seealso{
Use \code{\link{construct_weights}} to obtain \code{w_int} and \code{w_ext}.
}
\keyword{internal}
