% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_statCorr.R
\name{sm_statCorr}
\alias{sm_statCorr}
\title{Linear regression slope and statistical values (R or R2 and p values)
from a paired correlation test.}
\usage{
sm_statCorr(
  ...,
  fit.params = list(),
  corr_method = "pearson",
  alternative = "two.sided",
  separate_by = ",",
  label_x = NULL,
  label_y = NULL,
  text_size = 4,
  show_text = TRUE,
  borders = TRUE,
  legends = FALSE,
  r2 = FALSE,
  R2
)
}
\arguments{
\item{...}{Arguments for the properties of regression line, such as `linetype`, `color`, etc.
For more information, type ?geom_smooth}

\item{fit.params}{Paramters for the fitted line, such as color, linetype and alpha.}

\item{corr_method}{Method of the correlation test.
Options include: 'pearson', 'kendall', or 'spearman'.}

\item{alternative}{Specifies the alternative hypothesis (H1). 'two.sided' is the standard way.
'greater' is a positive association, whereas 'less' is a negative association.}

\item{separate_by}{This marks how the p- and r- values should be separated.
The default option is: ','
For more information, check out stat_cor() from the ggpubr package.}

\item{label_x}{Location of the statistical value prints along the figure's x-axis.
It asks for a number within the x-axis limit.}

\item{label_y}{Location of the statistical value prints along the figure's y-axis.
It requires a number within the y-axis limit.}

\item{text_size}{Size (numerical value) of the texts from correlation.}

\item{show_text}{If the statistical result needs to be displayed, the input should be TRUE (default).
If the statistical result is not needed, the input should be FALSE.}

\item{borders}{If the border needs to be displayed, the input should be TRUE.
If the border is not needed, the input should be FALSE.}

\item{legends}{If the legend needs to be displayed, the input should be TRUE.
If the legend is not needed, the input should be FALSE.}

\item{r2}{FALSE or TRUE. TRUE if user wants to compute R2. FALSE if R needs to be computed.}

\item{R2}{Same as r2.}
}
\value{
Plots a best-fitted linear regression on a correlation plot
with results from correlation statistical tests.
}
\description{
This combines two different functions:
1) `geom_smooth()` from ggplot, and 2) `stat_cor()` from ggpubr.
`geom_smooth()` is used to fit the best-fit model, whereas
`stat_cor()` is used to print correlation results at an optimized location.

Updates from smplot2 include more flexibility, less input arguments and its
pairing with `sm_hvgrid()` / `sm_corr_theme()`.
}
\examples{
library(smplot2)
library(ggplot2)
ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
  geom_point(shape = 21, fill = "#0f993d", color = "white", size = 3) +
  sm_statCorr() # computes R

ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
  geom_point(shape = 21, fill = "#0f993d", color = "white", size = 3) +
  sm_statCorr(R2 = TRUE) # computes R2

}
