% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_power.R
\name{sm_power}
\alias{sm_power}
\title{Post-hoc power analysis using two-sample or paired t-test}
\usage{
sm_power(group1, group2, paired, sig.level = 0.05, power = 0.8)
}
\arguments{
\item{group1}{Numeric vector containing data from one sample (i.e., group 1)
that is to be compared with another group.}

\item{group2}{Numeric vector containing data from another sample (i.e., group 2)
that is to be compared with the former group.}

\item{paired}{A logical indicating whether your two samples (group1 and group2) are paired.}

\item{sig.level}{Significance level (Type I error probability). Default is set to 0.05.}

\item{power}{Power of test (1 minus Type II error probability). Default is set to 0.8.}
}
\value{
Returns a result with a class of "power.htest" from the pwr package.
}
\description{
Post-hoc power analysis using two-sample or paired t-test
}
\examples{
library(smplot2)
group1 <- rnorm(10, 0, 1)
group2 <- rnorm(10, 1, 1)
sm_power(group1, group2, paired = TRUE)

}
