% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_pointplot.R
\name{sm_pointplot}
\alias{sm_pointplot}
\title{Point plot with optional shadow}
\usage{
sm_pointplot(
  ...,
  avgPoint.params = list(size = 2.5),
  avgLine.params = list(linewidth = 1),
  point.params = list(alpha = 0.35, color = "gray", fill = "gray"),
  line.params = list(alpha = 0.35, color = "gray"),
  err.params = list(linewidth = 1),
  errorbar_type = "se",
  show_shadow = FALSE,
  group = NULL,
  borders = TRUE,
  legends = FALSE,
  forget = FALSE
)
}
\arguments{
\item{...}{A generic aesthetic parameter across points, lines and errorbars. This is optional.
This will be extremely useful for dodging each line using position_dodge().}

\item{avgPoint.params}{List of parameters for the average point, such as color, alpha, fill etc}

\item{avgLine.params}{List of parameters for the average line, such as color, alpha etc}

\item{point.params}{List of parameters for the points in the shadow, such as color, alpha, fill etc}

\item{line.params}{List of parameters for the lines in the shadow, such as color, alpha etc}

\item{err.params}{List of parameters for the error bar from the average plot, such as color, alpha etc}

\item{errorbar_type}{This argument determines the errorbar type.
If it is set to 'se', standard error bar will be shown.
If it is set to 'sd' (default), the error bar will display standard deviation.
If it is set to 'ci', the error bar will display 95\% confidence interval.}

\item{show_shadow}{If it is TRUE, it will show the shadow.
If it is FALSE, it will not show the shadow (default).}

\item{group}{If show_shadow = TRUE, this argument is required. This is the variable that
each plot from the shadow should be grouped along aesthetically.
It should be grouped for each individual observation,
ex. sm_pointplot(group = Subject), whereby Subject is the column that holds identifers
for each observation.}

\item{borders}{If the border needs to be displayed, the input should be TRUE.
If the border is not needed, the input should be FALSE.}

\item{legends}{If the legend needs to be displayed, the input should be TRUE.
If the legend is not needed, the input should be FALSE.}

\item{forget}{Forget the defaults when list() is called for a specific parameter (ex. point.params).
Set to TRUE when when users want to map aesthetics to different groups more flexibly..
Set to FALSE by default.}
}
\value{
Returns a pointplot generated using ggplot2.
}
\description{
This is a common plot with mean point, standard error (se, sd or 95% CI) and
uniquely shadow, which is a faint display of individual points behind the mean.
}
\examples{
library(smplot2)
library(ggplot2)
ggplot(data = mtcars, mapping = aes(x = cyl, y = mpg)) +
  sm_pointplot()

}
