% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_hvgrid.R
\name{sm_hvgrid}
\alias{sm_hvgrid}
\title{A minimalistic theme with major horizontal and vertical grids}
\usage{
sm_hvgrid(legends = TRUE, borders = TRUE)
}
\arguments{
\item{legends}{If the legend needs to be displayed, the input should be TRUE.
If the legend is not needed, the input should be FALSE.}

\item{borders}{If the border needs to be displayed, the input should be `TRUE`.
If the border is not needed, the input should be `FALSE`.}
}
\value{
Returns a background theme that has both horizontal and vertical major grids (ggplot2 output).
}
\description{
This theme has major vertical and horizontal grids. This is useful for plotting correlations.
sm_corr_theme() is exactly the same as sm_hvgrid().
}
\examples{
library(ggplot2)
library(smplot2)
ggplot(data = mpg) +
  geom_point(mapping = aes(x = displ, y = hwy, color = class)) +
  sm_hvgrid()

}
