% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_common_ylabel.R
\name{sm_common_ylabel}
\alias{sm_common_ylabel}
\title{Common y-axis label (title) for combined subplots}
\usage{
sm_common_ylabel(
  label = "",
  size = 17,
  x = 0.5,
  y = 0.52,
  fontface = "plain",
  angle = 90
)
}
\arguments{
\item{label}{The input should be string.}

\item{size}{Text size of the label.}

\item{x}{Location of the label along the x-axis. Default is the middle origin (0.5).}

\item{y}{Location of the label along the y-axis. Default is the middle origin (0.5).}

\item{fontface}{The default is to set the text of the title as plain This can be changed, to
either "plain", "bold", "italic", "bold.italic" .}

\item{angle}{Orientation of the y-axis title. Default is 90 degrees.}
}
\value{
It returns a layer with the specified common y-axis label for combined plot.
}
\description{
Common y-axis label (title) for combined subplots
}
\examples{
library(smplot2)
sm_common_ylabel("My y-axis")
}
