% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremal_types_theorem.R
\name{ett}
\alias{ett}
\title{Extremal Types Theorem (ETT)}
\usage{
ett(
  n = 20,
  distn,
  params = list(),
  panel_plot = TRUE,
  hscale = NA,
  vscale = hscale,
  n_add = 1,
  delta_n = 1,
  arrow = TRUE,
  leg_cex = 1.25,
  ...
)
}
\arguments{
\item{n}{An integer scalar.  The size of the samples drawn from the
distribution chosen using \code{distn}.  \code{n} must be no smaller
than 2.}

\item{distn}{A character scalar specifying the distribution from which
  observations are sampled.   Distributions \code{"beta"},
  \code{"cauchy"}, \code{"chisq"}, \code{"chi-squared"},
  \code{"exponential"}, \code{"f"}, \code{"gamma"}, \code{"gp"},
  \code{"lognormal"}, \code{"log-normal"},  \code{"ngev"}, \code{"normal"},
  \code{"t"}, \code{"uniform"} and \code{"weibull"} are recognised, case
  being ignored.

  If \code{distn} is not supplied then \code{distn = "exponential"}
  is used.

  The \code{"gp"} case uses the \code{\link[revdbayes]{gp}}
  distributional functions in the
  \code{\link[revdbayes]{revdbayes}} package.

  The \code{"ngev"} case is a negated GEV(1 / \eqn{\xi}, 1, \eqn{\xi})
  distribution, for \eqn{\xi} > 0, and uses the \code{\link[revdbayes]{gev}}
  distributional functions in the
  \code{\link[revdbayes]{revdbayes}} package.
  If \eqn{\xi} = 1 then this coincides with Example 1.7.5 in Leadbetter,
  Lindgren and Rootzen (1983).

  The other cases use the distributional functions in the
  \code{\link[stats]{stats-package}}.
  If \code{distn = "gamma"} then the \code{(shape, rate)}
  parameterisation is used.  If \code{scale} is supplied via \code{params}
  then \code{rate} is inferred from this.
  If \code{distn = "beta"} then \code{ncp} is forced to be zero.}

\item{params}{A named list of additional arguments to be passed to the
  density function associated with distribution \code{distn}.
  The \code{(shape, rate)} parameterisation is used for the gamma
  distribution (see \code{\link[stats]{GammaDist}}) even if the value of
  the \code{scale} parameter is set using \code{params}.

  If a parameter value is not supplied then the default values in the
  relevant distributional function set using \code{distn} are used,
  except for
  \code{"beta"} (\code{shape1 = 2, shape2 = 2}),
  \code{"chisq"} (\code{df = 4}),
  \code{"f"} (\code{df1 = 4, df2 = 8}),
  \code{"ngev"} (\code{shape = 0.2}).
  \code{"gamma"} (\code{shape = 2},
  \code{"gp"} (\code{shape = 0.1}),
  \code{"t"} (\code{df = 4}) and
  \code{"weibull"} (\code{shape = 2}).}

\item{panel_plot}{A logical parameter that determines whether the plot
is placed inside the panel (\code{TRUE}) or in the standard graphics
window (\code{FALSE}).  If the plot is to be placed inside the panel
then the tkrplot library is required.}

\item{hscale, vscale}{Numeric scalars.  Scaling parameters for the size
of the plot when \code{panel_plot = TRUE}. The default values are 1.4 on
Unix platforms and 2 on Windows platforms.}

\item{n_add}{An integer scalar.  The number of simulated datasets to add
to each new frame of the movie.}

\item{delta_n}{A numeric scalar.  The amount by which n is increased
(or decreased) after one click of the + (or -) button in the parameter
window.}

\item{arrow}{A logical scalar.  Should an arrow be included to show the
simulated sample maximum from the top plot being placed into the
bottom plot?}

\item{leg_cex}{The argument \code{cex} to \code{\link[graphics]{legend}}.
Allows the size of the legend to be controlled manually.}

\item{...}{Additional arguments to the rpanel functions
\code{\link[rpanel]{rp.button}} and
\code{\link[rpanel]{rp.doublebutton}}, not including \code{panel},
\code{variable}, \code{title}, \code{step}, \code{action}, \code{initval},
\code{range}.}
}
\value{
Nothing is returned, only the animation is produced.
}
\description{
A movie to illustrate the extremal types theorem, that is, convergence
of the distribution of the maximum of a random sample of size \eqn{n}
from certain distributions to a member of the Generalized Extreme Value
(GEV) family, as \eqn{n} tends to infinity.
Samples of size \eqn{n} are simulated repeatedly from the chosen
distribution.  The distributions (simulated empirical and true) of the
sample maxima are compared to the relevant GEV limit.
}
\details{
Loosely speaking, a consequence of the
  \href{https://en.wikipedia.org/wiki/Extreme_value_theory#Univariate_theory}{Extremal Types Theorem}
  is that, in many situations, the maximum of a \emph{large number}
  \eqn{n} of independent random variables has \emph{approximately} a
  GEV(\eqn{\mu, \sigma, \xi)}) distribution, where \eqn{\mu} is a location
  parameter, \eqn{\sigma} is a scale parameter and \eqn{\xi} is a shape
  parameter.  See Coles (2001) for an introductory account and
  Leadbetter et al (1983) for greater detail and more examples.
  The Extremal Types Theorem is an asymptotic result that considers the
  possible limiting distribution of linearly normalised maxima
  as \eqn{n} tends to infinity.
  This movie considers examples where this limiting result holds and
  illustrates graphically the closeness of the limiting approximation
  provided by the relevant GEV limit to the true finite-\eqn{n}
  distribution.

  Samples of size \code{n} are repeatedly simulated from the distribution
  chosen using \code{distn}.  These samples are summarized using a histogram
  that appears at the top of the movie screen.  For each sample the maximum
  of these \code{n} values is calculated, stored and added to another plot,
  situated below the first plot.
  A \code{\link[graphics]{rug}} is added to a histogram provided that it
  contains no more than 1000 points.
  This plot is either a histogram or an empirical c.d.f., chosen using a
  radio button.

  The probability density function (p.d.f.) of the original
  variables is superimposed on the top histogram.
  There is a checkbox to add to the bottom plot the exact p.d.f./c.d.f. of
  the sample maxima and an approximate (large \code{n}) GEV p.d.f./c.d.f.
  implied by the ETT.
  The GEV shape parameter \eqn{\xi} that applies in the limiting
  case is used.  The GEV location \eqn{\mu} and scale
  \eqn{\sigma} are set based on constants used to normalise the maxima
  to achieve the GEV limit.
  Specifically, \eqn{\mu} is set at the 100(1-1/\eqn{n})\% quantile of the
  distribution \code{distn} and \eqn{\sigma} at
  (1 / \eqn{n}) / \eqn{f(\mu)}, where \eqn{f} is the
  density function of the distribution \code{distn}.

  Once it starts, four aspects of this movie are controlled by the user.
  \itemize{
    \item There are buttons to increase (+) or decrease (-) the sample
      size, that is, the number of values over which a maximum is
      calculated.
    \item Each time the button labelled "simulate another \code{n_add}
      samples of size n" is clicked \code{n_add} new samples are simulated
      and their sample maxima are added to the bottom histogram.
    \item There is a button to switch the bottom plot from displaying
      a histogram of the simulated maxima, the exact p.d.f. and the
      limiting GEV p.d.f. to the empirical c.d.f. of the simulated data,
      the exact c.d.f. and the limiting GEV c.d.f.
    \item There is a box that can be used to display only the bottom
      plot.  This option is selected automatically if the sample size
      \eqn{n} exceeds 100000.
    \item There is a box that can be used to display only the bottom
      plot.  This option is selected automatically if the sample size
      \eqn{n} exceeds 100000.
  }
  For further detail about the examples specified by \code{distn}
  see Chapter 1 of Leadbetter et al. (1983) and Chapter 3 of
  Coles (2001).  In many of these examples
  (\code{"exponential"}, \code{"normal"}, \code{"gamma"},
  \code{"lognormal"}, \code{"chi-squared"}, \code{"weibull"}, \code{"ngev"})
  the limiting GEV distribution has a shape
  parameter that is equal to 0.  In the \code{"uniform"} case the limiting
  shape parameter is -1 and in the \code{"beta"} case it is
  -1 / \code{shape2}, where \code{shape2} is the
  second parameter of the \code{\link[stats]{Beta}} distribution.
  In the other cases the limiting shape parameter is positive,
  with respective values \code{shape}
  (\code{"gp"}, see \code{\link[revdbayes]{gp}}),
  1 / \code{df} (\code{"t"}, see \code{\link[stats]{TDist}}),
  1 (\code{"cauchy"}, see \code{\link[stats]{Cauchy}}),
  2 / \code{df2} (\code{"f"}, see \code{\link[stats]{FDist}}).
}
\examples{
# Exponential data: xi = 0
ett()

# Uniform data: xi =-1
ett(distn = "uniform")

# Student t data: xi = 1 / df
ett(distn = "t", params = list(df = 5))
}
\references{
Coles, S. G. (2001) \emph{An Introduction to Statistical
  Modeling of Extreme Values}, Springer-Verlag, London.
  \doi{10.1007/978-1-4471-3675-0_3}

Leadbetter, M., Lindgren, G. and Rootzen, H. (1983)
  \emph{Extremes and Related Properties of Random Sequences and Processes.}
  Springer-Verlag, New York.
  \doi{10.1007/978-1-4612-5449-2}
}
\seealso{
\code{\link{movies}}: a user-friendly menu panel.

\code{\link{smovie}}: general information about smovie.
}
