% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_siteymlgen.R
\name{init}
\alias{init}
\title{Initiate the yaml generation}
\usage{
init(
  authors = "author",
  date = lubridate::today(),
  affiliation = NULL,
  dir = ".",
  left = "yes",
  right = NULL,
  navbar_title = "Title",
  title = "siteymlgen",
  categories = NULL,
  name = NULL,
  output_dir = NULL,
  include = NULL,
  exclude = NULL,
  toc = FALSE,
  toc_depth = NULL,
  toc_title = NULL,
  toc_float = FALSE,
  theme = "united",
  highlight = NULL,
  css = NULL,
  file = NULL
)
}
\arguments{
\item{authors}{A character or vector of characters of authors to add to the _site.yml}

\item{date}{A character or a vector of characters describing
the date}

\item{affiliation}{A character or a vector of characters describing the
authors affiliation. The affiliation which must match the length of the
vector supplied to \code{name}.}

\item{dir}{The directory of the Rmarkdown documents that you want automatically
built into a _site.yml file.}

\item{left}{A TRUE or FALSE value that determines if you want your navigation bar
left aligned. This is the default location.}

\item{right}{A TRUE or FALSE value that determines if you want your navigation bar
right aligned. Left aligned is the default location}

\item{navbar_title}{The title of the navigation bar. If none supplied this defaults
to "Title"}

\item{title}{A character describing the title of the website. This defaults to
"siteymlgen" if no value is supplied}

\item{categories}{A character or vector of characters describing the categories
for the website.}

\item{name}{A character or a vector of characters describing
the name of the author(s)}

\item{output_dir}{A character describing the output directory name for the final
Rmarkdown website.}

\item{include}{A character or vector of characters detailing the extra files to include
in the final Rmarkdown build}

\item{exclude}{A character or vector of characters detailing the files not to include
in the final Rmarkdown build}

\item{toc}{Specify whether a table of contents is required for your website, defaults
to TRUE}

\item{toc_depth}{An integer to specify the depth of the table of contents}

\item{toc_title}{A character that sets the toable of contents title}

\item{toc_float}{A boolean to specify if the table of contents is static or floats.
defaults to FALSE.}

\item{theme}{An Rmarkdown theme to set the render output. Defaults to 'united'.}

\item{highlight}{Syntax highlighting style for html_output from the rmarkdown package.
Supported styles include "default",
"tango", "pygments", "kate", "monochrome", "espresso", "zenburn", "haddock",
and "textmate". Pass NULL to prevent syntax highlighting}

\item{css}{Specify custom css.}

\item{file}{Specify the output filename.}
}
\value{
A _site.yml file populated with yaml code.
}
\description{
This function acts as an entry point for the initialisation of the yaml
generation.
}
\examples{
init(authors = c("Adam","Paul"), left="yes",
navbar_title = "Main title", title = "hello",
categories=c("r", "reprodicibility"), file=tempdir())
}
