% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-app.R
\name{test_app}
\alias{test_app}
\title{Test Shiny applications with \pkg{testthat}}
\usage{
test_app(
  app_dir = missing_arg(),
  ...,
  name = missing_arg(),
  reporter = testthat::get_reporter(),
  stop_on_failure = missing_arg(),
  check_setup = deprecated(),
  quiet = FALSE
)
}
\arguments{
\item{app_dir}{The base directory for the Shiny application.
\itemize{
\item If \code{app_dir} is missing and \code{test_app()} is called within the
\code{./tests/testthat.R} file, the parent directory (\code{"../"}) is used.
\item Otherwise, the default path of \code{"."} is used.
}}

\item{...}{Parameters passed to \code{\link[testthat:test_dir]{testthat::test_dir()}}}

\item{name}{Name to display in the middle of the test name. This value is
only used when calling \code{test_app()} inside of \pkg{testhat} test. The final
testing context will have the format of \code{"{test_context} - {name} - {app_test_context}"}.}

\item{reporter}{Reporter to pass through to \code{\link[testthat:test_dir]{testthat::test_dir()}}.}

\item{stop_on_failure}{If missing, the default value of \code{TRUE} will be used.
However, if missing and currently testing, \code{FALSE} will be used to
seamlessly integrate the app reporter to \code{reporter}.}

\item{check_setup}{\link{Deprecated}. Parameter ignored.}

\item{quiet}{If \code{TRUE}, suppresses deprecation warnings when called within
\pkg{testthat} tests.}
}
\description{
This is a helper method that wraps around \code{\link[testthat:test_dir]{testthat::test_dir()}} to test
your Shiny application or Shiny runtime document.  This is similar to how
\code{\link[testthat:test_package]{testthat::test_check()}} tests your R package but for your app.
}
\details{
Example usage:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{## Interactive usage
# Test Shiny app in current working directory
shinytest2::test_app()

# Test Shiny app in another directory
path_to_app <- "path/to/app"
shinytest2::test_app(path_to_app)

## File: ./tests/testthat.R
# Will find Shiny app in "../"
shinytest2::test_app()

## File: ./tests/testthat/test-shinytest2.R
# Test a shiny application within your own \{testthat\} code
test_that("Testing a Shiny app in a package", \{
  app <- shinytest2::AppDriver$new(path_to_app)
  # Perform tests with `app`...
\})
}\if{html}{\out{</div>}}

When testing within a package, it is recommended to not call \code{test_app()},
but instead test your applications within your own \pkg{testthat} tests. This
allows for more flexibility and control over how your applications are
tested while your current package's testthat infrastructure. See the \href{https://rstudio.github.io/shinytest2/articles/use-package.html}{Use Package vignette} for
more details.
}
\section{Uploading files}{


When testing an application, all non-temp files that are uploaded should be
located in the \code{./tests/testthat} directory. This allows for tests to be more
portable and self contained.

When recording a test with \code{\link[=record_test]{record_test()}}, for every uploaded file that is
located outside of \code{./tests/testthat}, a warning will be thrown. Once the
file path has be fixed, you may remove the warning statement.
}

\section{Different ways to test}{


\code{test_app()} is an opinionated testing function that will only execute
\pkg{testthat} tests in the \code{./tests/testthat} folder. If (for some rare
reason) you have other non-\pkg{testthat} tests to execute, you can call
\code{\link[shiny:runTests]{shiny::runTests()}}. This method will generically run all test runners and
their associated tests.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Execute a single Shiny app's \{testthat\} file such as `./tests/testthat/test-shinytest2.R`
test_app(filter = "shinytest2")

# Execute all \{testthat\} tests
test_app()

# Execute all tests for all test runners
shiny::runTests()
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \code{\link[=record_test]{record_test()}} to create tests to record against your Shiny
application.
\item \code{\link[testthat:snapshot_accept]{testthat::snapshot_review()}} and \code{\link[testthat:snapshot_accept]{testthat::snapshot_accept()}} if you
want to compare or update snapshots after testing.
\item \code{\link[=local_app_support]{local_app_support()}} / \code{\link[=with_app_support]{with_app_support()}} to load the Shiny
application's helper files into respective environments. These methods
are useful for within package testing as they have fine tune control over
when the support environment is loaded.
\item \code{\link[=load_app_support]{load_app_support()}} to load the Shiny application's helper files into
the calling environment. This method is useful for non-package based
Shiny applications where the support environment should be available in
every test file.
}
}
