% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creators.R
\name{create_question_random}
\alias{create_question_random}
\title{Create a random question}
\usage{
create_question_random(.f, n = 50)
}
\arguments{
\item{.f}{a function that outputs an object of class \code{quizQuestion}. This function can not have any arguments and must be able to produce random permutations of questions. The easiest way to ensure this is by including a \code{create_question} or \code{create_question_raw} call inside your function (see example).}

\item{n}{a numeric value indicating how many draws of function .f to include in the random question bank.}
}
\value{
a list of length n that includes objects of class \code{quizQuestionRandom}
}
\description{
Create questions with inherit randomness. Allows one function to generate many different questions.
}
\details{
\code{create_question_random()} takes any user generated function \code{.f}. The function passed to  the .\code{f} argument creates a random prompt along with an updated answer, the function passed to the \code{.f} argument must return an object of class \code{quizQuestion}. \code{create_question_random()} will automatically check to ensure the function passed to \code{.f} is in the appropriate format. The \code{n} argument controls how many random draws from  the function passed to \code{.f} are included in the question bank for the quiz. Higher values of \code{n} allow more unique questions but extreme values of \code{n} may also lead to slower performance. To create a quiz with \code{n} randomly generated questions, \code{create_question_random()} can be passed as an argument to \code{create_quiz()}.
}
\examples{
# a function that generates a random question
random_question <- function() {
  number <- round(rnorm(1, 30, 10), 0)
  rand_prompt <- paste('Is', number, 'an even number?')
  
  # using create_question inside the function helps to ensure correct class
  q <- create_question(
    prompt = rand_prompt,
    add_choice('Yes, it is even', correct = number \%\% 2 == 0), 
    add_choice('No, it is odd', correct = number \%\% 2 != 0)
  )
  
  return(q)
}

# create a quiz with a question bank of 20 randomly generated questions
quiz <- create_quiz(
  create_question_random(.f = random_question, n = 20)
)
}
\author{
George Perrett, Joseph Marlo
}
