% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aceDiffEditor.R
\name{aceDiffEditor}
\alias{aceDiffEditor}
\title{Render an Ace aceDiffEditor}
\usage{
aceDiffEditor(
  valueA,
  valueB,
  mode = "ace/mode/text",
  enableSpellCheck = FALSE,
  ...,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{valueA}{\link{character}: Set text to first editor when initializing}

\item{valueB}{\link{character}: Set text to second editor when initializing}

\item{mode}{\link{character}: The Ace \code{shinyEditor::getAceModes()} to be used by the editor}

\item{enableSpellCheck}{\link{logical}: Enable check typo of spelling}

\item{...}{For more \code{EditorOption}, please refer to \url{https://ace.c9.io/api/interfaces/ace.Ace.EditorOptions.html}}

\item{width}{\link{integer}, \link{character}: Width in pixels (optional, defaults to automatic sizing)}

\item{height}{\link{integer}, \link{character}: Height in pixels (optional, defaults to automatic sizing)}

\item{elementId}{\link{character}: An element id for the widget (a random character by default)}
}
\value{
Widget for shiny application
}
\description{
Render an Ace diff editor on an application page.
}
\examples{
if(interactive()){
    shinyEditor::aceDiffEditor(valueA = "text1", valueB = "text2")
}
}
