% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpi0est.R
\name{fpi0est}
\alias{fpi0est}
\title{Estimate Functional Proportion of Null Tests}
\usage{
fpi0est(
  p,
  pi0_model_obj = NULL,
  z = NULL,
  pi0_model = NULL,
  indep_snps = NULL,
  lambda = seq(0.05, 0.95, 0.05),
  constrained.p = TRUE,
  tol = 1e-09,
  maxit = 200,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{p}{Numeric vector of p-values.}

\item{pi0_model_obj}{Optional list object returned by \code{\link{pi0_model}}.
Must contain \code{fmod} (formula) and \code{zt} (rank-transformed covariates).
If provided, \code{z} and \code{pi0_model} are extracted automatically.
Default is NULL.}

\item{z}{Optional data frame or matrix of rank-transformed covariates.
Required if \code{pi0_model_obj} is not provided. Default is NULL.}

\item{pi0_model}{Optional formula (as character string or formula object).
Required if \code{pi0_model_obj} is not provided. Default is NULL.}

\item{indep_snps}{Optional logical vector indicating independent SNPs for
model fitting. Default is NULL (all SNPs used).}

\item{lambda}{Numeric vector of lambda thresholds. Default is \code{seq(0.05, 0.95, 0.05)}.}

\item{constrained.p}{Logical; use constrained binomial family. Default is TRUE.}

\item{tol}{Numeric; convergence tolerance. Default is 1e-9.}

\item{maxit}{Integer; maximum iterations. Default is 200.}

\item{verbose}{Logical; print progress messages. Default is TRUE.}

\item{...}{Additional arguments passed to \code{\link[fastglm]{fastglm}}.}
}
\value{
An object of class \code{fpi0} (a list) containing:
\describe{
  \item{fpi0}{Numeric vector of functional pi0 estimates for each test.}
  \item{tableLambda}{A data frame summarizing results for each lambda value.}
  \item{MISE}{The Mean Integrated Squared Error (MISE) for the chosen model.}
  \item{lambda}{The selected optimal lambda value.}
}
}
\description{
Estimates the functional proportion of null tests (pi0) using a GLM approach
with a constrained binomial family. This function fits models across multiple
lambda thresholds and selects the optimal estimate via MISE minimization.
}
\details{
\strong{Algorithm:}

\enumerate{
  \item For each lambda threshold, fit a binomial GLM: \eqn{P(p \ge \lambda | z)}
  \item Use constrained binomial family to ensure predictions in (0, 1)
  \item Select optimal lambda via MISE minimization
}

\strong{Usage Patterns:}

\strong{Pattern 1 (Recommended):} Use output from \code{\link{pi0_model}}
\preformatted{
  mpi0 <- pi0_model(z)
  # Clean syntax:
  fpi0_out <- fpi0est(p, mpi0)
}

\strong{Pattern 2:} Manually specify formula and covariates
\preformatted{
  fpi0_out <- fpi0est(p, z = z_matrix, pi0_model = formula_obj)
}
}
\examples{
# Import data
data(bmi)

# Separate main p-values and conditioning p-values
p <- sumstats$bmi
z <- as.matrix(sumstats[, -1])

# Apply pi0_model to create model (uses adaptive knot selection)
fmod <- pi0_model(z)

# Estimate functional pi0
fpi0_out <- fpi0est(p, fmod)
fpi0 <- fpi0_out$fpi0

# Apply sffdr
sffdr_out <- sffdr(p, fpi0)

}
