% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{check_required_sysenv}
\alias{check_required_sysenv}
\title{Check required values for system environment variables}
\usage{
check_required_sysenv(action = "warn", required_sysenv = NULL)
}
\arguments{
\item{action}{Behaviour to take if the status is not clean. Possible values are
"error", "warn", "message", and "none". The default is \code{action = "warn"}.}

\item{required_sysenv}{A named list of required system environment variables.
If any of these variables are missing or have different values to the required
values, an action is triggered.}
}
\value{
Invisibly returns an object of class \code{sessioncheck_status}.
}
\description{
Individual session check function that inspects system environment variables.
Session checkers can produce errors, warnings, or messages if requested.
}
\examples{
check_required_sysenv(action = "message", required_sysenv = list(R_TEST = "value"))

}
\seealso{
\code{\link[=check_attached_packages]{check_attached_packages()}},
\code{\link[=check_loaded_namespaces]{check_loaded_namespaces()}},
\code{\link[=check_globalenv_objects]{check_globalenv_objects()}},
\code{\link[=check_attached_environments]{check_attached_environments()}},
\code{\link[=check_sessiontime]{check_sessiontime()}},
\code{\link[=check_required_options]{check_required_options()}},
\code{\link[=check_required_locale]{check_required_locale()}},
\code{\link[=check_required_sysenv]{check_required_sysenv()}}
}
