% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{check_attached_packages}
\alias{check_attached_packages}
\title{Check attached packages}
\usage{
check_attached_packages(action = "warn", allow_attached_packages = NULL)
}
\arguments{
\item{action}{Behaviour to take if the status is not clean. Possible values are
"error", "warn", "message", and "none". The default is \code{action = "warn"}.}

\item{allow_attached_packages}{Character vector containing names of packages that
are "allowed", and will not trigger an action if attached to the search path.}
}
\value{
Invisibly returns an object of class \code{sessioncheck_status}.
}
\description{
Individual session check function that inspects the attached packages.
Session checkers can produce errors, warnings, or messages if requested.
}
\details{
This checker inspects the list of packages that have been
attached to the search path (e.g., via \code{library()}). Regardless of the value of
\code{allow}, R packages that have "base" priority (e.g., \strong{base}, \strong{utils}, and
\strong{grDevices}) do not trigger an action. When \code{allow = NULL} these are the only
packages that will not trigger actions.
}
\examples{
check_attached_packages(action = "message")
 
}
\seealso{
\code{\link[=check_attached_packages]{check_attached_packages()}},
\code{\link[=check_loaded_namespaces]{check_loaded_namespaces()}},
\code{\link[=check_globalenv_objects]{check_globalenv_objects()}},
\code{\link[=check_attached_environments]{check_attached_environments()}},
\code{\link[=check_sessiontime]{check_sessiontime()}},
\code{\link[=check_required_options]{check_required_options()}},
\code{\link[=check_required_locale]{check_required_locale()}},
\code{\link[=check_required_sysenv]{check_required_sysenv()}}
}
