% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigen_indices.R
\name{esim}
\alias{esim}
\title{Linear Phenotypic Eigen Selection Index (ESIM)}
\usage{
esim(pmat, gmat, selection_intensity = 2.063, n_indices = 1L)
}
\arguments{
\item{pmat}{Phenotypic variance-covariance matrix (n_traits x n_traits).}

\item{gmat}{Genotypic variance-covariance matrix (n_traits x n_traits).
Corresponds to \strong{C} in the Chapter 7 notation.}

\item{selection_intensity}{Selection intensity constant \eqn{k_I}
(default: 2.063 for 10\% selection).}

\item{n_indices}{Number of leading ESIM vectors to return (default: 1).
Returning >1 provides a ranked set of indices for comparative analysis.}
}
\value{
Object of class \code{"esim"}, a list with:
\describe{
  \item{\code{summary}}{Data frame with b coefficients, hI2, rHI, sigma_I,
    Delta_G, and lambda2 for each index requested.}
  \item{\code{b}}{Named numeric vector of optimal ESIM coefficients (1st index).}
  \item{\code{Delta_G}}{Named numeric vector of expected genetic gains per trait.}
  \item{\code{sigma_I}}{Standard deviation of the index \eqn{\sigma_I}.}
  \item{\code{hI2}}{Index heritability \eqn{h^2_{I_E}} (= leading eigenvalue).}
  \item{\code{rHI}}{Accuracy \eqn{r_{HI_E}}.}
  \item{\code{lambda2}}{Leading eigenvalue (maximised index heritability).}
  \item{\code{implied_w}}{Implied economic weights \eqn{\mathbf{w}_E}.}
  \item{\code{all_eigenvalues}}{All eigenvalues of \eqn{\mathbf{P}^{-1}\mathbf{C}}.}
  \item{\code{selection_intensity}}{Selection intensity used.}
}
}
\description{
Implements the ESIM by maximising the squared accuracy \eqn{\rho_{HI}^2}
through the generalised eigenproblem of the multi-trait heritability matrix
\eqn{\mathbf{P}^{-1}\mathbf{C}}.

Unlike the Smith-Hazel LPSI, **no economic weights are required**.  The net
genetic merit vector \eqn{\mathbf{w}_E} is instead implied by the solution.
}
\details{
\strong{Eigenproblem (Section 7.1):}
\deqn{(\mathbf{P}^{-1}\mathbf{C} - \lambda_E^2 \mathbf{I})\mathbf{b}_E = 0}

The solution \eqn{\lambda_E^2} (largest eigenvalue) equals the maximum
achievable index heritability \eqn{h^2_{I_E}}.

\strong{Key metrics:}
\deqn{R_E = k_I \sqrt{\mathbf{b}_E^{\prime}\mathbf{P}\mathbf{b}_E}}
\deqn{\mathbf{E}_E = k_I \frac{\mathbf{C}\mathbf{b}_E}{\sqrt{\mathbf{b}_E^{\prime}\mathbf{P}\mathbf{b}_E}}}

\strong{Implied economic weights:}
\deqn{\mathbf{w}_E = \frac{\sqrt{\lambda_E^2}}{\mathbf{b}_E^{\prime}\mathbf{P}\mathbf{b}_E} \mathbf{C}^{-1}\mathbf{P}\mathbf{b}_E}

Uses \code{cpp_symmetric_solve} and \code{cpp_quadratic_form_sym} from
\code{math_primitives.cpp} for efficient matrix operations, and R's
\code{eigen()} for the eigendecomposition.
}
\examples{
\dontrun{
gmat <- gen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])
pmat <- phen_varcov(seldata[, 3:9], seldata[, 2], seldata[, 1])

result <- esim(pmat, gmat)
print(result)
summary(result)
}
}
\references{
Ceron-Rojas, J. J., & Crossa, J. (2018). Linear Selection Indices in Modern
Plant Breeding. Springer International Publishing. Section 7.1.
}
