% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sehr.R
\name{get_outdegrees}
\alias{get_outdegrees}
\alias{get_hypernyms}
\alias{get_hyponyms}
\alias{get_holonyms}
\alias{get_meronyms}
\alias{get_causes}
\alias{get_antonyms}
\alias{get_derivatives}
\alias{get_pertainyms}
\alias{list_linktypes}
\title{Get outdegrees}
\usage{
get_outdegrees(x, linkid = 1)

get_hypernyms(x)

get_hyponyms(x)

get_holonyms(x)

get_meronyms(x)

get_causes(x)

get_antonyms(x)

get_derivatives(x)

get_pertainyms(x)

list_linktypes()
}
\arguments{
\item{x}{character, one or more Synset IDs to be searched, or a data.frame result from another \code{get_} function}

\item{linkid}{a vector of numeric linkids. Use \code{\link[=list_linktypes]{list_linktypes()}} to obtain a full list.}
}
\value{
a data frame containing search result
}
\description{
Search for outdegrees based on linkid. Various sugars are also provided with different default linkids.
}
\examples{
\donttest{
if (interactive()) {
get_lemmas("dog", pos = "n", sensenum = 1) \%>\% get_outdegrees(linkid = 1)
get_lemmas("dog", pos = "n", sensenum = 1) \%>\% get_hyponyms()
get_lemmas("nice", pos = "a", sensenum = 1) \%>\% get_antonyms()
}
}
}
