% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.r
\name{compare_scholar_careers}
\alias{compare_scholar_careers}
\title{Compare the careers of multiple scholars}
\usage{
compare_scholar_careers(ids, career = TRUE)
}
\arguments{
\item{ids}{a character vector of Google Scholar IDs}

\item{career}{a boolean, should a column be added to the results
measuring the year relative to the first citation year.  Default =
TRUE}
}
\description{
Compares the careers of multiple scholars based on their citation
histories.  The scholar's \emph{career} is defined by the number
of citations to his or her work in a given year (i.e. the bar
chart at the top of a scholar's profile). The function has an
\code{career} option that allows users to compare scholars
directly, i.e. relative to the first year in which their
publications are cited.
}
\examples{
  ## How do Richard Feynmann and Stephen Hawking compare?
  # Compare Feynman and Stephen Hawking
  ids <- c("B7vSqZsAAAAJ", "DO5oG40AAAAJ")
  df <- compare_scholar_careers(ids)

}
