% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breaks-by-width.R
\name{brk_width-for-datetime}
\alias{brk_width-for-datetime}
\alias{brk_width.Duration}
\title{Equal-width intervals for dates or datetimes}
\usage{
\method{brk_width}{Duration}(width, start)
}
\arguments{
\item{width}{A scalar \link{difftime}, \link[lubridate:Period-class]{Period} or
\link[lubridate:Duration-class]{Duration} object.}

\item{start}{A scalar of class \link{Date} or \link[=DateTimeClasses]{POSIXct}.
Can be omitted.}
}
\description{
\code{brk_width()} can be used with time interval classes from base R or the
\code{lubridate} package.
}
\details{
If \code{width} is a Period, \code{\link[lubridate:mplus]{lubridate::add_with_rollback()}}
is used to calculate the widths. This can be useful for e.g. calendar months.
}
\examples{

if (requireNamespace("lubridate")) {
  year2001 <- as.Date("2001-01-01") + 0:364
  tab_width(year2001, months(1),
        labels = lbl_discrete(" to ", fmt = "\%e \%b \%y"))
}

}
