% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixOps.R
\name{rvec-matrix-mult}
\alias{rvec-matrix-mult}
\alias{\%*\%,Matrix,rvec-method}
\alias{\%*\%,rvec,Matrix-method}
\title{Matrix Multiplication with Rvecs}
\usage{
\S4method{\%*\%}{Matrix,rvec}(x, y)

\S4method{\%*\%}{rvec,Matrix}(x, y)
}
\arguments{
\item{x, y}{Vectors, matrices, or rvecs}
}
\value{
An rvec if one or both
of the inputs is an rvec;
otherwise the default
\code{\%*\%} result.
}
\description{
Matrix multiplication \code{\%*\%} can be used
with \link[=rvec]{rvecs}, provided that the
version of R in use is version 4.3.0 or higher.
}
\details{
Multiplying an rvec by a matrix produces
an rvec, with no dimensions. This is
different from an ordinary R vector:
multiplying an ordinary vector by a
matrix produces a row or column matrix.
}
\examples{
if (getRversion() >= "4.3.0") {
  A <- matrix(c(10, 10, 10,
                11, 11, 11),
              nrow = 2, byrow = TRUE)
  x <- rvec(list(c(1, 2),
                 c(3, 4),
                 c(5, 6)))
  A \%*\% x
}
}
