% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert-to-rs.R
\name{convert_to_rstudio_theme}
\alias{convert_to_rstudio_theme}
\title{Convert a TextMate or VS Code/Positron theme to an RStudio theme}
\usage{
convert_to_rstudio_theme(
  path,
  outfile = tempfile(fileext = ".rstheme"),
  name = NULL,
  use_italics = TRUE,
  output_style = "expanded",
  force = FALSE,
  apply = FALSE
)
}
\arguments{
\item{path}{Path or URL to a TextMate theme (\code{.tmTheme} format) or a Visual
Studio Code theme (\code{.json} format).}

\item{outfile}{Path where the resulting file will be written. By default
a temporary file (\code{\link[=tempfile]{tempfile()}}).}

\item{name}{Optional. The name of the theme. If not provided, the name of
the theme in \code{path} will be used.}

\item{use_italics}{Logical. Whether to use italics in the resulting theme.
By default \code{TRUE}; however, some themes may look better without italics.}

\item{output_style}{Bracketing and formatting style of the CSS output.
Possible styles: \code{"nested"}, \code{"expanded"}, \code{"compact"}, and
\code{"compressed"}.}

\item{force}{Whether to force the operation and overwrite an existing file
with the same name.\cr Default: \code{FALSE}.}

\item{apply}{Logical. Apply the theme with \code{\link[rstudioapi:applyTheme]{rstudioapi::applyTheme()}}.}
}
\value{
This function is called for its side effects. It writes a new
\code{.rstheme} file to \code{outfile} and returns the path. If \code{force} or \code{apply}
are \code{TRUE}, it will install and apply the theme to your RStudio IDE.
}
\description{
Read a \code{.tmTheme} or \code{.json} file that defines a TextMate or Visual
Studio Code theme and write the equivalent RStudio theme \code{.rstheme}.

Optionally, the generated theme can be installed and applied to the
RStudio IDE.

\strong{Important}: This function only works in RStudio; it returns \code{NULL} when
called from other IDEs.
}
\details{
RStudio supports custom editor themes in two formats: \code{.tmTheme} and
\code{.rstheme}. The \code{.tmTheme} format originated with TextMate and has become a
common theme format.
\href{https://tmtheme-editor.linuxbox.ninja/}{This tmTheme editor} hosts a large
collection of \code{.tmTheme} files. The \code{.rstheme} format is specific to RStudio.

To switch editor themes, go to \verb{Tools > Global Options > Appearance > Add}
and use the Editor theme selector.

\if{html}{
  \out{<div style="text-align: center">}

   \figure{rstudiogui.png}{options: alt="RStudio IDE, Add-Theme UI"
       style="max-width:80\%;"}

   \out{</div>}
}

For more information, see
\url{https://docs.posit.co/ide/user/ide/guide/ui/appearance.html}.
}
\examples{
if (on_rstudio() && interactive()) {
  vstheme <- system.file("ext/skeletor-syntax-color-theme.json",
    package = "rstudiothemes"
  )

  # Apply the theme for 10 seconds to demonstrate the effect

  current_theme <- rstudioapi::getThemeInfo()$editor

  # Current theme name:
  current_theme
  new_rs_theme <- convert_to_rstudio_theme(vstheme,
    name = "A testing theme",
    apply = TRUE, force = TRUE
  )

  Sys.sleep(10)

  rstudioapi::applyTheme(current_theme)
  rstudioapi::removeTheme("A testing theme")
}
}
\seealso{
\code{\link[rstudioapi:addTheme]{rstudioapi::addTheme()}}, \code{\link[rstudioapi:applyTheme]{rstudioapi::applyTheme()}}

Other functions for creating themes: 
\code{\link{convert_tm_to_vs_theme}()},
\code{\link{convert_vs_to_tm_theme}()}
}
\concept{functions for creating themes}
