% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.utilities.R
\name{ult<-}
\alias{ult<-}
\alias{ult}
\title{Extract or replace the *ult*imate (last) element of a vector or a list, or an element counting from the end.}
\usage{
ult(x, i = 1L) <- value

ult(x, i = 1L)
}
\arguments{
\item{x}{a vector or a list.}

\item{i}{index from the end of the list to extract or replace (where 1 is the last element, 2 is the penultimate element, etc.).}

\item{value}{Replacement value for the `i`th element from the end.}
}
\value{
An element of `x`.
}
\description{
Extract or replace the *ult*imate (last) element of a vector or a list, or an element counting from the end.
}
\note{
Due to the way in which assigning to a function is
  implemented in R, `ult(x) <- e` may be less efficient than
  `x[[length(x)]] <- e`.
}
\examples{
(x <- c(1:5))
(ult(x) <- 6)
(ult(x, 2) <- 7) # 2nd last.
x

\dontshow{
stopifnot(all(x == c(1:3, 7L, 6L)))
}

x <- 1:5
(last <- ult(x))
(penultimate <- ult(x, 2)) # 2nd last.

\dontshow{
stopifnot(last==5)
stopifnot(penultimate==4)
}

}
