% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{funmad}
\alias{funmad}
\title{The functional normalized median absolute deviation estimators}
\usage{
funmad(X, ...)
}
\arguments{
\item{X}{Either an object of class  \code{fdata} for monodimensional functional data  or an object of class \code{fdata2d} for bi-dimensional functional data.}

\item{...}{Additional argument to be passed to \code{fusem}.}
}
\value{
The FuNMAD estimator.
}
\description{
Compute  the functional normalized median absolute deviation (FuNMAD) estimator  as described in Centofanti et al. (2023).
}
\examples{

library(rofanova)
data_out<-simulate_data(scenario="one-way")
X_fdata<-data_out$X_fdata
per_list_median<-funmad(X_fdata)
}
\references{
Centofanti, F., Colosimo, B. M., Grasso, M. L., Menafoglio, A., Palumbo, B., & Vantini, S. (2023).
Robust functional ANOVA with application to additive manufacturing.
\emph{Journal of the Royal Statistical Society Series C: Applied Statistics}, 72(5), 1210-1234.
\emph{arXiv preprint arXiv:2112.10643}.
}
\seealso{
\code{\link{rofanova}} \code{\link{fusem}}
}
