% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data}
\alias{data}
\alias{get_vic_study_area}
\alias{get_vic_cost}
\alias{get_vic_pa}
\alias{get_vic_species}
\alias{get_vic_species_metadata}
\title{Conservation planning dataset for Victoria, Australia}
\format{
\describe{
\item{\code{get_vic_study_area()}}{\code{\link[sf:sf]{sf::st_sf()}} object.}
\item{\code{get_vic_cost()}}{\code{\link[terra:rast]{terra::rast()}} object}
\item{\code{get_vic_species()}}{\code{\link[terra:rast]{terra::rast()}} object}
\item{\code{get_vic_pa()}}{\code{\link[terra:rast]{terra::rast()}} object}
\item{\code{vic_species_metadata()}}{\code{\link[tibble:tibble]{tibble::tibble()}} object}
}
}
\usage{
get_vic_study_area()

get_vic_cost()

get_vic_pa()

get_vic_species()

get_vic_species_metadata()
}
\description{
This is a conservation planning dataset for Victoria, Australia
that can be used to generate robust prioritizations.
This dataset was derived from Archibald \emph{et al.} (2024),
Department of Climate Change, Energy, the Environment and Water (2024),
Global Administrative Areas (2024), and Williams \emph{et al.} (2020).
For an example of using this dataset, please refer to the
the \emph{Example using Victoria, Australia} vignette
(\code{vignette("vic-cons-planning", package = "robust.prioritizr")}).
}
\details{
Briefly, this dataset contains
1.2988 × 10\if{html}{\out{<sup>}}4\if{html}{\out{</sup>}} planning units and
18 terrestrial vertebrate
species For each species, the dataset contains the present-day spatial
distribution for the species as well as projections for the species' future
spatial distribution at
4
time periods based on
4
combinations of climate models and scenarios.
To account for existing conservation efforts, the dataset also
contains the locations of existing protected areas.

The following functions are provided to import the dataset:

\describe{

\item{\code{get_vic_study_area()}}{
A \code{\link[sf:sf]{sf::st_sf()}} object containing the spatial boundary of the Victoria,
Australia (derived from Global Administrative Areas 2024).
}

\item{\code{get_vic_cost()}}{
A \code{\link[terra:rast]{terra::rast()}} object containing the opportunity costs associated
with protected area establishment (derived from Williams \emph{et al.} 2020).
This object contains a single layer, and grid cells denote planning units.
Cells contain positive continuous values, such that greater values denote
greater opportunity costs.
}

\item{\code{get_vic_pa()}}{
A \code{\link[terra:rast]{terra::rast()}} object containing the locations of existing protected areas
(derived from DCCEEW 2024).
This object contains a single layer, and grid cells denote planning units.
Cells contain binary values indicating if existing protected areas cover, at
least, 50\% of the grid cell or not.
}

\item{\code{get_vic_species()}}{
A \code{\link[terra:rast]{terra::rast()}} object containing the present-day and potential future
spatial distributions of terrestrial vertebrate species
(derived from Archibald \emph{et al.} 2024).
This object contains a 306 layers,
where each layer corresponds to the predicted spatial distribution of a
particular species at a particular point in time based on a particular
climate scenario. For a given layer, grid cells denote planning units.
Cells contain binary values indicating if the species is predicted to be
present or absent within the cell.
}

\item{\code{get_vic_species_metadata()}}{
A \code{\link[tibble:tibble]{tibble::tibble()}} data frame containing information on the species'
spatial distribution data (i.e., \code{get_vic_species()}).
Here, each row of the \code{dadta.frame}
corresponds to each layer of species' spatial distribution data,
and columns describe different aspects of the layers.
This object contains columns with the following values.

\describe{

\item{id}{
\code{integer} index values for the layers. E.g., the fifth layer is associated
with an \code{id} value of 5.
}

\item{id}{
\code{character} names for the layers. These values correspond to
\code{names(get_vic_species())}.
}

\item{species}{
\code{character} scientific names of the species associated with the layers.
}

\item{class}{
\code{character} taxonomic classes of the species associated with the layers.
}

\item{proj}{
\code{character} names of the climate projections and timesteps associated with
the layers.
Layers that represent the species' present-day distributions are denoted
with a value of \code{"historic_baseline_1990"}.
Also, layers that represent the species' potential future distributions
denoted with values of \code{"GCM-Ensembles_ssp126_2030"}, \code{"GCM- Ensembles_ssp126_2050"}, \code{"GCM-Ensembles_ssp126_2070"}, \code{"GCM- Ensembles_ssp126_2090"}, \code{"GCM-Ensembles_ssp245_2030"},
\code{"GCM- Ensembles_ssp245_2050"}, \code{"GCM-Ensembles_ssp245_2070"},
\code{"GCM-Ensembles_ssp245_2090"}, \code{"GCM-Ensembles_ssp370_2030"},
\code{"GCM-Ensembles_ssp370_2050"}, \code{"GCM-Ensembles_ssp370_2070"},
\code{"GCM-Ensembles_ssp370_2090"}, \code{"GCM-Ensembles_ssp585_2030"},
\code{"GCM-Ensembles_ssp585_2050"}, \code{"GCM-Ensembles_ssp585_2070"}, and
\code{"GCM-Ensembles_ssp585_2090"}.
Note that these values provide the same information as the
\code{timestep} and \code{scenario} columns, and are provided to help
with subsetting the data.
}

\item{timestep}{
\code{numeric} year of the datasets used to generate the layers.
Layers that represent the
species' present-day distributions are denoted with a year of \code{1990}, and
layers that represent the species' potential future distributions
denoted with years of \code{2030}, \code{2050}, \code{2070}, and \code{2090}.
}

\item{scenario}{
\code{character} names of the climate scenarios used to generate the layers.
Layers that represent the
species' present day distributions are denoted with \code{"historic_baseline"}.
Also, layers that represent species' future distributions are
associated with a particular Shared Socioeconomic Pathway (SSP) and
Representative Concentration Pathways (RCP), such as
(\code{"ssp126"}) SSP 1 and RCP 2.6, (\code{"ssp245"}) SSP 2 and RCP 4.5,
(\code{"ssp370"}) SSP 3 and RCP 7.0, and (\code{"ssp585"}) SSP 5 and RCP 8.5.
}

\item{sum}{
\code{numeric} number of planning units where the species are predicted to be
present within each of the layers.
}

}

}

}
}
\examples{
# load spatial R packages
library(sf)
library(terra)

# load data
vic_study_area <- get_vic_study_area()
vic_cost <- get_vic_cost()
vic_species <- get_vic_species()
vic_pa <- get_vic_pa()
 vic_species_metadata <- get_vic_species_metadata()

# preview data
print(vic_species_metadata)
print(vic_study_area)
print(vic_cost)
print(vic_species)
print(vic_pa)

# visualize data
plot(vic_study_area, main = "vic_study_area")
plot(vic_cost, main = "vic_cost")
plot(vic_species, main = "vic_species")
plot(vic_pa, main = "vic_pa")
}
\references{
Archibald CL, Summers DM, Graham EM, Bryan B (2024) Habitat suitability maps
for Australian flora and fauna under CMIP6 climate scenarios.
\emph{GigaScience}, 13:giae002.

DCCEEW (2024), Collaborative Australian Protected Areas Database (CAPAD).

Global Administrative Areas (2024). Database of Global Administrative Areas.
Version 4.1. Available at https://gadm.org (accessed on 15 August 2025).

Williams BA, Venter O, Allan JR, Atkinson SC, Rehbein JA, Ward M,
Di Marco M, Grantham HS, Ervin J, Goetz SJ, Hansen AJ, Jantz P, Pillay R,
Rodríguez-Buriticá S, Supples C, Virnig ALS, Watson JEM (2020)
Change in terrestrial human footprint drives continued loss of intact
ecosystems. \emph{One Earth}, 3:371--382.
}
\seealso{
The code used to prepare this dataset are available online
(\url{https://github.com/jeffreyhanson/robust.prioritizr.data}),
}
\keyword{datasets}
