% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{bugs2juliaBUGS}
\alias{bugs2juliaBUGS}
\title{Convert Bayesian Updating for Gibbs Sampling (BUGS) Model to Julia's `@bugs` Macro Format}
\usage{
bugs2juliaBUGS(model_code, convert_var_name = TRUE)
}
\arguments{
\item{model_code}{A character string containing the BUGS model code.}

\item{convert_var_name}{Logical; if \code{TRUE} (default), R-style variable names
(e.g., \code{a.b.c}) are converted to Julia-style (\code{a_b_c}). Set to \code{FALSE}
to preserve the original names.}
}
\value{
A character string representing a valid Julia `@bugs` macro call. This string can
be evaluated in Julia to define the BUGS model with optional variable name conversion.
}
\description{
This function formats a Bayesian Updating for Gibbs Sampling (BUGS) model string
into Julia's `@bugs("""...""", convert_var_name, true)` macro syntax, used to run
BUGS models in Julia. By default, R-style variable names (e.g., `a.b.c`) are converted
to Julia-style (`a_b_c`). You can disable this behavior by setting `convert_var_name = FALSE`.
}
\examples{
\dontrun{
model <- "
  for i in 1:N
    y[i] ~ dnorm(mu, tau)
  end
  mu ~ dnorm(0.0, 1.0E-6)
  tau ~ dgamma(0.001, 0.001)
"
bugs2juliaBUGS(model)
bugs2juliaBUGS(model, convert_var_name = FALSE)
}

}
