
# rjuliabugs <img src="man/figures/logo.png" align="right" alt="" />

<!-- badges: start -->

[![License:
MIT](https://img.shields.io/badge/license-MIT-blue.svg)](https://opensource.org/licenses/MIT)
<!-- [![R build status](https://github.com/MateusMaiaDS/rjuliabugs/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/MateusMaiaDS/rjuliabugs/actions) -->
<!-- [![R-CMD-check](https://github.com/MateusMaiaDS/rjuliabugs/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/MateusMaiaDS/rjuliabugs/actions/workflows/R-CMD-check.yaml) -->
<!-- badges: end -->

**rjuliabugs** is an R package that provides a bridge between R and
[JuliaBUGS](https://github.com/TuringLang/JuliaBUGS.jl?tab=readme-ov-file),
the [BUGS](https://en.wikipedia.org/wiki/WinBUGS)-style Bayesian
modeling interface developed in Julia as part of the
[Turing.jl](https://turing.ml/dev/) probabilistic programming ecosystem.

**JuliaBUGS** allows users to define models using the familiar BUGS
syntax while leveraging the speed and flexibility of the Julia language.
It enables automatic translation of BUGS code into modern probabilistic
programs that run efficiently with advanced inference engines such as
Hamiltonian Monte Carlo (HMC) — all accessible via Turing.jl.

With `rjuliabugs`, R users can run BUGS models/code through JuliaBUGS
and take advantage of the inference algorithms available in Turing.jl,
without leaving the R environment. This not only provides a seamless
path to adopt faster (including
[parallelization](https://mateusmaiads.github.io/rjuliabugs/articles/rjuliabugs_parallel.html))
and more flexible sampling methods but also allows integration with R’s
extensive post-processing ecosystem (e.g., `bayesplot`, `posterior`,
`coda`). It lowers the barrier for existing BUGS users to adopt modern
Bayesian tools without abandoning their existing model codebase.

## Installation

You can install the development version of **rjuliabugs** from
[GitHub](https://github.com/MateusMaiaDS/rjuliabugs) with:

``` r
# install.packages("remotes")
remotes::install_github("MateusMaiaDS/rjuliabugs")
```

⚠️ **Loading the package**:  
When starting a R session for the first time, after loading the package
`rjuliabugs` and before running any function, we recommend to run
`rjuliabugs::setup_juliaBUGS()` to build all Julia setup in R and
install any needed dependencies. We recommend this initially as it an be
time-consuming. See `?rjuliabugs::setup_juliaBUGS` for more details.

For further guidance, there articles in this page which summarize most
of the FAQ and additional instructions for installing Julia and setting
`rjuliabugs`, troubleshooting, and running `rjuliabugs` in parallel. We
recommend the reading of them before working with `rjuliabugs`:

- [Installing
  Julia](https://mateusmaiads.github.io/rjuliabugs/articles/setup_troubleshooting.html#installing-julia)
- [Troubleshooting JuliaCall
  setup](https://mateusmaiads.github.io/rjuliabugs/articles/setup_troubleshooting.html#troubleshooting-juliacall-setup)
  - [Julia not
    found](https://mateusmaiads.github.io/rjuliabugs/articles/setup_troubleshooting.html#error-type-julia-not-found)
  - [R not
    found](https://mateusmaiads.github.io/rjuliabugs/articles/setup_troubleshooting.html#error-type-r_home-not-found)
  - [Other installation
    issues](https://mateusmaiads.github.io/rjuliabugs/articles/setup_troubleshooting.html#other-installations-issues)
- [Using `rjuliabugs` in
  parallel](https://mateusmaiads.github.io/rjuliabugs/articles/rjuliabugs_parallel.html)

## Contributing

Contributions are welcome! If you encounter a bug or have a feature
request, please open an
[issue](https://github.com/MateusMaiaDS/rjuliabugs/issues).

## License

This package is licensed under the MIT License. See the
[LICENSE](LICENSE) file for details.

## Acknowledgements

This project is part of a Google Summer of Code 2025 initiative under
the [Turing.jl](https://turing.ml/dev/) organization. The mentors were
Xianda Sun and Robert Goudie.
