% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivs.R
\name{rxp_py}
\alias{rxp_py}
\title{Create a Nix Expression Running a Python Function}
\usage{
rxp_py(
  name,
  expr,
  additional_files = "",
  user_functions = "",
  nix_env = "default.nix",
  encoder = NULL,
  decoder = NULL,
  env_var = NULL,
  noop_build = FALSE
)
}
\arguments{
\item{name}{Symbol, name of the derivation.}

\item{expr}{Character, Python code to generate the expression. Ideally it
should be a call to a pure function. Multi-line expressions are not
supported.}

\item{additional_files}{Character vector, additional files to include
during the build process. For example, if a function expects a certain
file to be available, this is where you should include it.}

\item{user_functions}{Character vector, user-defined functions to include.
This should be a script (or scripts) containing user-defined functions
to include during the build process for this derivation. It is recommended
to use one script per function, and only include the required script(s) in
the derivation.}

\item{nix_env}{Character, path to the Nix environment file, default is
"default.nix".}

\item{encoder}{Character, defaults to NULL. The name of the Python
function used to serialize the object. It must accept two arguments: the
object to serialize (first), and the target file path (second). If NULL,
the default behaviour uses \code{pickle.dump}. Define this function in
\code{functions.py}. See \code{vignette("encoding-decoding")} for more details.}

\item{decoder}{Character or named vector/list, defaults to NULL. Can be:
\itemize{
\item A single string for the Python function to unserialize all upstream objects
\item A named vector/list where names are upstream dependency names and values
are their specific unserialize functions
If NULL, the default uses \code{pickle.load}. See \code{vignette("encoding-decoding")} for more details.
}}

\item{env_var}{Character vector, defaults to NULL. A named vector of
environment variables
before running the Python script, e.g., c(PYTHONPATH = "/path/to/modules").
Each entry will be added as an export statement in the build phase.}

\item{noop_build}{Logical, defaults to FALSE. If TRUE, the derivation
produces a no-op build (a stub output with no actual build steps). Any
downstream derivations depending on a no-op build will themselves also
become no-op builds.}
}
\value{
An object of class derivation which inherits from lists.
}
\description{
Create a Nix Expression Running a Python Function
}
\details{
At a basic level,
\code{rxp_py(mtcars_am, "mtcars.filter(polars.col('am') == 1).to_pandas()")}
is equivalent to
\verb{mtcars_am = mtcars.filter(polars.col('am') == 1).to_pandas()}. \code{rxp_py()}
generates the required Nix boilerplate to output a so-called "derivation"
in Nix jargon. A Nix derivation is a recipe that defines how to create an
output (in this case \code{mtcars_am}) including its dependencies, build steps,
and output paths.
}
\examples{
\dontrun{
  rxp_py(
    mtcars_pl_am,
    expr = "mtcars_pl.filter(polars.col('am') == 1).to_pandas()"
  )

  # Skip building this derivation
  rxp_py(
    data_prep,
    expr = "preprocess_data(raw_data)",
    noop_build = TRUE
  )

  # Custom serialization
  rxp_py(
    mtcars_pl_am,
    expr = "mtcars_pl.filter(polars.col('am') == 1).to_pandas()",
    user_functions = "functions.py",
    encoder = "serialize_model",
    additional_files = "some_required_file.bin")
}
}
\seealso{
Other derivations: 
\code{\link{rxp_jl}()},
\code{\link{rxp_jl_file}()},
\code{\link{rxp_py_file}()},
\code{\link{rxp_qmd}()},
\code{\link{rxp_r}()},
\code{\link{rxp_r_file}()},
\code{\link{rxp_rmd}()}
}
\concept{derivations}
