% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxp_inspect.R
\name{rxp_inspect}
\alias{rxp_inspect}
\title{Inspect the Build Result of a Pipeline}
\usage{
rxp_inspect(project_path = ".", which_log = NULL)
}
\arguments{
\item{project_path}{Character, defaults to ".".
Path to the root directory of the project.}

\item{which_log}{Character, defaults to NULL. If NULL the most recent
build log is used. If a string is provided, it's used as a
regular expression to match against available log files.}
}
\value{
A data frame with derivation names, if their build was successful,
their paths in the /nix/store, and their build outputs.
}
\description{
Returns a data frame with four columns:
- derivation: the name of the derivation
- build_success: whether the build was successful or not
- path: the path of this derivation in the Nix store
- output: the output, if this derivation was built successfully.
Empty outputs mean that this derivation was not built
successfully. Several outputs for a single derivation
are possible.
In the \code{derivation} column you will find an object called \code{all-derivations}.
This object is generated automatically for internal purposes, and you can
safely ignore it.
}
\examples{
\dontrun{
  # Inspect the most recent build
  build_results <- rxp_inspect()

  # Inspect a specific build log
  build_results <- rxp_inspect(which_log = "20250510")

  # Check which derivations failed
  failed <- subset(build_results, !build_success)
}
}
\seealso{
Other utilities: 
\code{\link{print.rxp_derivation}()},
\code{\link{rxp_check_chronicles}()},
\code{\link{rxp_copy}()},
\code{\link{rxp_gc}()},
\code{\link{rxp_init}()},
\code{\link{rxp_list_logs}()},
\code{\link{rxp_load}()},
\code{\link{rxp_read}()},
\code{\link{rxp_trace}()}
}
\concept{utilities}
