% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_github_data.R
\name{get_commits_since}
\alias{get_commits_since}
\title{Retrieve GitHub Commits as Weekly Counts (using curl)}
\usage{
get_commits_since(owner, repo, years = 1)
}
\arguments{
\item{owner}{Character. The GitHub username or organization that owns the repository.}

\item{repo}{Character. The name of the GitHub repository.}

\item{years}{Numeric. Number of years to look back from today's date (default is 1).}
}
\value{
A data frame with four columns:
\describe{
  \item{week_start}{Start date of the week (class \code{Date}).}
  \item{year}{Year of the commits.}
  \item{month}{Month of the commits.}
  \item{n_commits}{Number of commits during the week.}
}
}
\description{
This function fetches all commits from a specified GitHub repository
using the GitHub API and returns a data frame with weekly commit counts.
}
\examples{
\dontrun{
# Get commit counts for the past year
get_commits_since(owner = "tidyverse", repo = "ggplot2")
}

}
