% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cossim.R
\name{cossim}
\alias{cossim}
\title{Calculate the cosine similarity between two vectors (matrices)}
\usage{
cossim(x, y, na.rm = TRUE)
}
\arguments{
\item{x}{An integer or numeric vector or matrix}

\item{y}{An integer or numeric vector or matrix}

\item{na.rm}{Logical, whether \code{NA} should be removed}
}
\value{
Numeric vector or matrix, the cossine similarity between the inputs
}
\description{
Calculate the cosine similarity between two vectors (matrices)
}
\details{
If given as vectors, \code{x} and \code{y} must be of the same
length. If given as matrices, both must have the same number of
rows. If given as a pair of matrix and vector, the length of the
vector must match the row number of the matrix. Otherwise the 
function aborts and prints error message.

If parameters are given as matrices, the function calculates the cossine similarity between all pair of \emph{columns} of both matrices.

If \code{na.rm} is set \code{FALSE}, any \code{NA} in the input vectors
will cause the result to be \code{NA}, or \code{NaN} if all values
turn out to be \code{NA}.
}
\note{
Currently, \code{na.rm} is only considered when both inputs are vectors
}
\examples{
testVal1 <- rnorm(10)
testVal2 <- rnorm(10)
testVal3 <- c(rnorm(9), NA)

cossim(testVal1, testVal2)
cossim(testVal1, testVal3, na.rm=TRUE)
cossim(testVal1, testVal3, na.rm=FALSE)

cosdist(testVal1, testVal2)
cosdist(testVal1, testVal3, na.rm=TRUE)
cosdist(testVal1, testVal3, na.rm=FALSE)
## test matrix
testMat1 <- matrix(rnorm(1000), nrow=10)
testMat2 <- matrix(rnorm(1000), nrow=10)
system.time(testMatCos <- cossim(testMat1, testMat2))

testMatVec <- cossim(testMat1, testMat2[,1L])
testVecMat <- cossim(testMat1[,1L], testMat2)

}
\references{
\url{https://en.wikipedia.org/wiki/Cosine_similarity}
}
\seealso{
\code{\link{cor}}, \code{\link{cosdist}}
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
