% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeMatrix.R
\name{readTable}
\alias{readTable}
\title{Read in data.frame from tab-delimited format written by \code{writeMatrix}}
\usage{
readTable(file, row.names = TRUE, ...)
}
\arguments{
\item{file}{file to be read in}

\item{row.names}{Logical, whether the first column contains row names (should be consistent with the settign in \code{writeMatrix})}

\item{...}{Other parameters passed to \code{read.table}, for instance \code{stringsAsFactors}. Following parameters are \emph{not} allowed to change: \code{header, sep, quote, dec, check.names, strip.wrhite, comment.char}.}
}
\value{
A \code{data.frame} object
}
\description{
\code{readTable} reads a data.frame written by \code{writeMatrix} into a R session
}
\details{
Default behaviour of \code{read.table} is adapted to the convention used in \code{writeMatrix}
}
\examples{
test.df <- data.frame(Team=c("HSV", "BVB", "VFB"), Score=c(21, 19, 17))
tmpfile <- tempfile()
writeMatrix(test.df, tmpfile)
readin.df <- readTable(tmpfile)
stopifnot(identical(as.character(readin.df$Team), c("HSV", "BVB", "VFB")))
stopifnot(identical(readin.df$Score, c(21L, 19L, 17L)))
}
