/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.common.jocl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jocl.CL;
import org.jocl.Pointer;
import org.jocl.Sizeof;
import org.jocl.cl_device_id;
import org.jocl.cl_platform_id;
import usf.saav.common.jocl.joclPlatform;

public class joclController {
    joclPlatform[] platforms;

    public joclController(boolean bl) {
        CL.setExceptionsEnabled((boolean)true);
        int[] nArray = new int[1];
        CL.clGetPlatformIDs((int)0, null, (int[])nArray);
        int n = nArray[0];
        this.platforms = new joclPlatform[n];
        cl_platform_id[] cl_platform_idArray = new cl_platform_id[n];
        CL.clGetPlatformIDs((int)cl_platform_idArray.length, (cl_platform_id[])cl_platform_idArray, null);
        for (int i = 0; i < n; ++i) {
            this.platforms[i] = new joclPlatform(cl_platform_idArray[i], bl);
        }
    }

    public joclPlatform getPlatform(int n) {
        return this.platforms[n];
    }

    public int getPlatformCount() {
        return this.platforms.length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Number of platforms: " + this.platforms.length + "\n");
        for (joclPlatform joclPlatform2 : this.platforms) {
            stringBuilder.append(joclPlatform2.toString());
        }
        return stringBuilder.toString();
    }

    public static int getInt(cl_device_id cl_device_id2, int n) {
        return joclController.getInts(cl_device_id2, n, 1)[0];
    }

    public static int[] getInts(cl_device_id cl_device_id2, int n, int n2) {
        int[] nArray = new int[n2];
        CL.clGetDeviceInfo((cl_device_id)cl_device_id2, (int)n, (long)(4 * n2), (Pointer)Pointer.to((int[])nArray), null);
        return nArray;
    }

    public static long getLong(cl_device_id cl_device_id2, int n) {
        return joclController.getLongs(cl_device_id2, n, 1)[0];
    }

    public static long[] getLongs(cl_device_id cl_device_id2, int n, int n2) {
        long[] lArray = new long[n2];
        CL.clGetDeviceInfo((cl_device_id)cl_device_id2, (int)n, (long)(8 * n2), (Pointer)Pointer.to((long[])lArray), null);
        return lArray;
    }

    public static String getString(cl_device_id cl_device_id2, int n) {
        long[] lArray = new long[1];
        CL.clGetDeviceInfo((cl_device_id)cl_device_id2, (int)n, (long)0L, null, (long[])lArray);
        byte[] byArray = new byte[(int)lArray[0]];
        CL.clGetDeviceInfo((cl_device_id)cl_device_id2, (int)n, (long)byArray.length, (Pointer)Pointer.to((byte[])byArray), null);
        return new String(byArray, 0, byArray.length - 1);
    }

    public static String getString(cl_platform_id cl_platform_id2, int n) {
        long[] lArray = new long[1];
        CL.clGetPlatformInfo((cl_platform_id)cl_platform_id2, (int)n, (long)0L, null, (long[])lArray);
        byte[] byArray = new byte[(int)lArray[0]];
        CL.clGetPlatformInfo((cl_platform_id)cl_platform_id2, (int)n, (long)byArray.length, (Pointer)Pointer.to((byte[])byArray), null);
        return new String(byArray, 0, byArray.length - 1);
    }

    public static long getSize(cl_device_id cl_device_id2, int n) {
        return joclController.getSizes(cl_device_id2, n, 1)[0];
    }

    public static long[] getSizes(cl_device_id cl_device_id2, int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2 * Sizeof.size_t).order(ByteOrder.nativeOrder());
        CL.clGetDeviceInfo((cl_device_id)cl_device_id2, (int)n, (long)(Sizeof.size_t * n2), (Pointer)Pointer.to((Buffer)byteBuffer), null);
        long[] lArray = new long[n2];
        if (Sizeof.size_t == 4) {
            for (int i = 0; i < n2; ++i) {
                lArray[i] = byteBuffer.getInt(i * Sizeof.size_t);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                lArray[i] = byteBuffer.getLong(i * Sizeof.size_t);
            }
        }
        return lArray;
    }

    public static void main(String[] stringArray) {
        System.out.println(new joclController(true).toString());
    }
}

