% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_description.R
\name{change_remotes_field}
\alias{change_remotes_field}
\title{Change the \code{Remotes} field in DESCRIPTION}
\usage{
change_remotes_field(
  path,
  target = c("develop", "snapshot", "main"),
  verbose = TRUE
)
}
\arguments{
\item{path}{[\link[base]{character}] Path to the package root directory.}

\item{target}{[\link[base]{character}] Target branch or type of remote:
must be one of \code{"develop"}, \code{"snapshot"}, or \code{"main"}.}

\item{verbose}{[\link[base]{logical}] Whether to print current and new
remote fields (default: \code{TRUE}).}
}
\value{
Invisibly returns the new vector of remote specifications
(character).
}
\description{
Update the \code{Remotes} field of a package DESCRIPTION file so that
dependencies point to specific development targets
(\code{develop}, \code{snapshot}, or \code{main}).
}
\examples{
path_rjd3workspace <- file.path(tempdir(), "rjd3workspace")
file.copy(
    from = system.file("rjd3workspace", package = "releaser"),
    to = dirname(path_rjd3workspace),
    recursive = TRUE
)

change_remotes_field(path = path_rjd3workspace, target = "develop")

}
