% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_clean.R
\name{refdb_clean_seq_crop_primers}
\alias{refdb_clean_seq_crop_primers}
\title{Crop genetic sequences with a set of primers}
\usage{
refdb_clean_seq_crop_primers(
  x,
  primer_forward,
  primer_reverse,
  max_error_in = 0.1,
  max_error_out = 0.1,
  include_primers = TRUE
)
}
\arguments{
\item{x}{a reference database with a defined sequence field.}

\item{primer_forward}{primer forward.}

\item{primer_reverse}{primer reverse.}

\item{max_error_in, max_error_out}{maximum error for a match
(frequency based on primer length).}

\item{include_primers}{a logical indicating whether the detected primers are
included in the cropped sequences.}
}
\value{
A reference database.
}
\description{
Crop genetic sequences with a set of primers
}
\examples{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
refdb_clean_seq_crop_primers(lib, "AGT", "TTTA")

}
