% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_rcdf.R
\name{merge_rcdf}
\alias{merge_rcdf}
\title{Merge multiple RCDF files}
\usage{
merge_rcdf(
  rcdf_files,
  decryption_keys,
  passwords,
  merged_file_path,
  pub_key = NULL
)
}
\arguments{
\item{rcdf_files}{A character vector of RCDF file paths}

\item{decryption_keys}{Decryption keys associated with each RCDF file. Must match the length of the vector passed in the \code{rcdf_files} argument.}

\item{passwords}{Password of the associated decryption keys. Must match the length of \code{decryption_keys}.}

\item{merged_file_path}{File path or name of the merged RCDF file.}

\item{pub_key}{Public key to encrypt the merged file. If \code{NULL}, a new RSA key pair will be generated.}
}
\value{
\code{NULL} (void)
}
\description{
Merge multiple RCDF files
}
\examples{
dir <- system.file("extdata", package = "rcdf")

rcdf_path <- file.path(dir, 'mtcars-pw.rcdf')
private_key <- file.path(dir, 'sample-private-key-pw.pem')
pw <- '1234'

temp_dir <- tempdir()

data <- merge_rcdf(
  rcdf_files = rcdf_path,
  decryption_keys = private_key,
  passwords = pw,
  merged_file_path = file.path(temp_dir, "merged.rcdf")
)

unlink(temp_dir, force = TRUE)
}
