% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libbi.R
\name{attach_data}
\alias{attach_data}
\alias{attach_data.libbi}
\title{Attach a new file or data set to a \code{\link{libbi}} object}
\usage{
\method{attach_data}{libbi}(
  x,
  file,
  data,
  in_place = FALSE,
  append = FALSE,
  overwrite = FALSE,
  quiet = FALSE,
  time_dim = character(0),
  coord_dims = list(),
  ...
)
}
\arguments{
\item{x}{a \code{\link{libbi}} object}

\item{file}{the type of the file to attach, one of "output", "obs", "input"
or "init"}

\item{data}{name of the file to attach, or a list of data frames
that contain the outputs; it will be assumed that this is already thinned}

\item{in_place}{if TRUE, replace the file in place if it already exists in
the libbi object; this can speed up the operation if append=TRUE as
otherwise the file will have to be read and used again; it should be used
with care, though, as it can render existing \code{\link{libbi}} objects
invalid as the files they are pointing to are changed.}

\item{append}{if TRUE, will append variables if file exists; default: FALSE}

\item{overwrite}{if TRUE, will overwrite variables if file exists; default:
FALSE}

\item{quiet}{if TRUE, will suppress the warning message normally given if
replace=TRUE and the file exists already}

\item{time_dim}{the name of the time dimension, if one exists; default:
"time"}

\item{coord_dims}{the names of the coordinate dimension, if any; should be a
named list of character vectors, they are matched to variables names}

\item{...}{any options to \code{\link{bi_write}} (e.g., 'time_dim')}
}
\value{
an updated \code{\link{libbi}} object
}
\description{
Adds an (output, obs, etc.) file to a \code{\link{libbi}} object. This is
  useful to recreate a \code{\link{libbi}} object from the model and output
  files of a previous run

The \code{\link{bi_write}} options \code{append} and \code{overwrite}
  determine what exactly the file will contain at the end of this. If they
  are both FALSE (the default), any existing file will be ignored. If
  \code{append} is TRUE, the existing data in the file will be preserved, and
  any data set passed as \code{data} and not already in the file will be
  added. If \code{overwrite} is TRUE, existing data in the file will be
  preserved except for variables that exist in the passed \code{data}.
}
\examples{
bi <- libbi(model = system.file(package = "rbi", "PZ.bi"))
example_output <- bi_read(system.file(package = "rbi", "example_output.nc"))
bi <- attach_data(bi, "output", example_output)
}
