% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flows-spline.r
\name{splinepwlinflowmodel}
\alias{splinepwlinflowmodel}
\title{Piecewise-Linear Spline Flow (Monotone)}
\usage{
splinepwlinflowmodel(d = 2, K = 8, theta = NULL)
}
\arguments{
\item{d}{Dimension of the latent space.}

\item{K}{Number of spline bins.}

\item{theta}{Optional parameter vector. If NULL, random initialization.}
}
\value{
A flow model object with methods:
\itemize{
  \item sampleq(n)
  \item logq(z0)
  \item applyflow(z0)
}
}
\description{
A readable implementation of a monotone piecewise-linear spline flow.
Each dimension is transformed independently using learned spline parameters.
}
\details{
The spline flow uses:
\itemize{
  \item \eqn{K} bins with learned widths \eqn{w} and heights \eqn{h}
  \item a softmax transformation to ensure positivity and normalization
  \item a sigmoid reparameterization for numerical stability
}

The flow is invertible and differentiable almost everywhere.
}
