% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_rap_table.R
\name{get_rap_table}
\alias{get_rap_table}
\alias{get_rap_production16day_table}
\title{Query RAP Tabular Data}
\usage{
get_rap_table(
  aoi,
  years = NULL,
  product,
  version = "V3",
  mask = TRUE,
  nodata_flag = NA_real_
)

get_rap_production16day_table(
  aoi,
  years = NULL,
  mask = TRUE,
  nodata_flag = NA_real_,
  ...
)
}
\arguments{
\item{aoi}{Area of Interest. A \code{SpatVector} object, or any spatial object
that can be converted with \code{terra::vect()}. The AOI coordinates will be
transformed to WGS84 longitude latitude (\code{"EPSG:4326"}). The AOI can be
specified using point, line and polygon geometries. Each unique feature
will be passed separately to the API. The result \code{feature} column contains
the row index of the input feature from \code{aoi}.}

\item{years}{integer. Optional. Numeric year or vector of years (1986 to last
full year). Default: \code{NULL} returns all available years.}

\item{product}{Target data: \code{"cover"}, \code{"coverMeteorology"},
\code{"production"}, or \code{"production16day"}.}

\item{version}{Target version: \code{"V3"}.}

\item{mask}{logical. Exclude cropland, development, and water? Default:
\code{TRUE}.}

\item{nodata_flag}{numeric. Value to use for missing data. The API encodes
"NODATA" as \code{-99}. Default: \code{NA_real_} replaces \code{-99} with \code{NA}.}

\item{...}{allows backward compatibility with \code{year} argument in depreciated
version of \code{get_rap_production16day_table()}.}
}
\value{
A \emph{data.frame} with requested time-series data by year or 16-day
production period. In addition to the columns described in Details above, all
products include columns for \code{"year"} (production estimate year) and
\code{"feature"} (feature ID, row number from \code{aoi}). Units are \strong{\% cover} for
fractional cover and \strong{lbs / acre} for production.
}
\description{
Retrieves remotely sensed production or cover estimates from the Rangeland
Analysis Platform (RAP) using the tabular data API endpoints. This function
supports querying one or more spatial features (points, lines, or polygons)
provided as a \code{terra} \code{SpatVector} object, or any spatial object that can be
converted with \code{terra::vect()}. See Details for the products available.

\code{get_rap_production16day_table()} is depreciated, please use
\code{get_rap_table(product="production16day")} instead.
}
\details{
For each feature - year combination, a separate request is made to the RAP
API, and results are returned as a combined \code{data.frame}. In the special case
of (\code{years=NULL}) default, all available years are returned in a single query.

For more information on the API and data products, see the RAP API
documentation: \url{https://rangelands.app/support/71-api-documentation}
\subsection{Products Overview}{

You can query several Landsat derived biomass, cover, and meteorological
products from 1986 to present:
\itemize{
\item \code{"cover"} -- yearly fractional cover, including:
\itemize{
\item \code{"AFG"} (Annual Forb and Grass cover)
\item \code{"PFG"} (Perennial Forb and Grass cover)
\item \code{"SHR"} (Shrub cover)
\item \code{"TRE"} (Tree cover)
\item \code{"LTR"} (Litter cover)
\item \code{"BGR"} (Bare Ground cover)
}
\item \code{"coverMeteorology"} -- the same data provided by \code{"cover"} above, plus:
\itemize{
\item \code{"annualTemp"} (Annual average temperature in degrees Fahrenheit)
\item \code{"annualPrecip"} (Annual total precipitation in inches)
}
\item \code{"production"} -- annual production, including:
\itemize{
\item \code{"AFG"} (Annual Forb and Grass production)
\item \code{"PFG"} (Perennial Forb and Grass production)
\item \code{"HER"} (Herbaceous production)
}
\item \code{"production16day"} -- 16-day production, including:
\itemize{
\item \code{"date"} (production estimate date)
\item \code{"doy"} (production estimate Julian day of year)
\item \code{"AFG"} (Annual Forb and Grass production)
\item \code{"PFG"} (Perennial Forb and Grass production)
\item \code{"HER"} (Herbaceous production)
}
}
}
}
\examples{
\dontshow{if (requireNamespace("terra") && isTRUE(as.logical(Sys.getenv("R_RAPR_EXTENDED_EXAMPLES", unset=FALSE)))) withAutoprint(\{ # examplesIf}
aoi <- terra::vect(data.frame(x = -119.72330, y = 36.92204),
                   geom = c('x', 'y'),
                   crs = "EPSG:4326")

# all years (years=NULL) fractional cover data
res <- get_rap_table(aoi, product="cover")
str(res)

# specific year fractional cover and meteorological data 
res <- get_rap_table(aoi, years = 1992, product="coverMeteorology")
str(res)

# multiple specific years above-ground production (annual)
res <- get_rap_table(aoi, years = 1993:2003, product="production")
str(res)

# 1 kilometer buffer around point, above-ground production (16 days) in 2004
res <- get_rap_table(terra::buffer(aoi, 1000), years = 2004, product="production16day")
str(res)
\dontshow{\}) # examplesIf}
}
