% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_cond_prob.r
\name{shortSummary}
\alias{shortSummary}
\title{Generate Short Summary of Grouped Data after the Output by calc_cond_prob}
\usage{
shortSummary(df, coln = "Weekday , wkhwk.c.bp", combination = 1)
}
\arguments{
\item{df}{A data.frame containing the raw data to be summarized. 
The DataFrame must include the columns specified in the `coln` parameter for grouping.}

\item{coln}{A comma-separated string of column names to be used for grouping in the summary. 
Whitespace will be trimmed from the specified column names.
For example: "Weekday, wkhwk.c.bp".}

\item{combination}{An integer indicating how to handle column combinations for the summary.
When set to 1, the function generates all possible combinations of the columns 
specified in `coln`. For any other value, only the specified columns will be used.}
}
\value{
A list of data.frames containing the summarized results for each group based on the specified columns.
        Each data.frame will include the specified grouping columns, 
        the sum of hits (`hit_sum`), the sum of totals (`total_sum`), 
        and the calculated odds (`odd`).

A list.
}
\description{
Generate Short Summary of Grouped Data after the Output by calc_cond_prob
}
\examples{
## Prepare some sample data          
df<-data.frame(exam_lang_score=c(80,88,85,82,34,34),age=c(6,7,8,6,7,8),height =c(5,6,6,7,5,7))
## Find P(exam_lang_score >= 80 ~ age + height) 
## where age is divided into 3 groups and height into 4 groups.   
res=calc_cond_prob(df, "exam_lang_score >= 80 ~ age + height", range_list=list( 3,4))
## Use the results to calculate the conditional probability for 
## the power set of 'age' and 'height'.             
shortSummary(res[[1]], "age + height ", combination=1)
}
