% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_cond_prob.r
\name{goodchance}
\alias{goodchance}
\title{Filter Data Based on Odds}
\usage{
goodchance(df, col_name = "odd", upper = 0.75, lower = 0.25)
}
\arguments{
\item{df}{A data.frame containing the data to be evaluated. 
The DataFrame must include the column specified by `col_name` containing odds values.}

\item{col_name}{A string representing the name of the column in the DataFrame that contains the odds values.
The default is 'odd', which means the function will look for an 'odd' column in the DataFrame.}

\item{upper}{A numeric threshold for the upper bound of the odds. 
Rows with an 'odd' value greater than or equal to this threshold will be included in the output.
The default value is 0.75.}

\item{lower}{A numeric threshold for the lower bound of the odds. 
Rows with an 'odd' value less than or equal to this threshold and greater than 0 
will also be included in the output. The default value is 0.25.}
}
\value{
A filtered data.frame containing only the rows where the odds meet the specified conditions 
        (either above the upper threshold or below the lower threshold and greater than 0).
}
\description{
Filter Data Based on Odds
}
\examples{
## Prepare some sample data       
df<-data.frame(exam_lang_score=c(80,88,85,82,34,34),age=c(6,7,8,6,7,8),height =c(5,6,6,7,5,7))
## Find P(exam_lang_score >= 80 ~ age + height) 
## where age is divided into 3 groups and height into 4 groups.   
res=calc_cond_prob(df, "exam_lang_score >= 80 ~ age + height", range_list=list( 3,4))
## Use the results to calculate the conditional probability for 
## the power set of 'age' and 'height'.         
summary_result_list=shortSummary(res[[1]], "age + height ", combination=1)
## Extract the results of the high and low odds obtained from 
## executing the cal_cond_prob() function. 
lapply(summary_result_list, goodchance, upper=0.7, lower=0.25)
}
