% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_cond_prob.r
\name{calc_cond_prob}
\alias{calc_cond_prob}
\title{Calculate Conditional Probability}
\usage{
calc_cond_prob(
  clean_data,
  formula_string = NULL,
  range_list,
  cond_evaluation = NULL,
  col_name_list = NULL,
  verbose = FALSE
)
}
\arguments{
\item{clean_data}{A data.frame containing input data for analysis. 
It must include all variables referenced in `formula_string` and `col_name_list`.}

\item{formula_string}{An optional formula string in the format 'y ~ x1 + x2 + ...'.
This specifies the relationship between dependent and independent variables.
If provided, it determines the conditional evaluation and the list of column names.}

\item{range_list}{A list of ranges or boundaries corresponding to each column in `col_name_list`.
This parameter is mandatory and must contain appropriate range definitions.}

\item{cond_evaluation}{An optional string for the conditional evaluation expression.
If not provided, it defaults to the left-hand side of `formula_string`.}

\item{col_name_list}{An optional list of column names for the analysis.
If not specified, it is derived from `formula_string`.}

\item{verbose}{A boolean indicating more message. 
When set to TRUE, additional output will be printed to help trace the computation steps.}
}
\value{
A list containing the results of the conditional probability calculation, 
        the good chance evaluation, and the adjusted range list.
}
\description{
Calculate Conditional Probability
}
\examples{
## Prepare some sample data       
df<-data.frame(exam_lang_score=c(80,88,85,82,34,34),age=c(6,7,8,6,7,8),height =c(5,6,6,7,5,7))
## Find P(exam_lang_score >= 80 ~ age ) where age is divided into 3 groups.                                     
calc_cond_prob(df, "exam_lang_score >= 80  ~ age ",  range_list=list(3))

## Find P(exam_lang_score >= 80 ~ age  ) 
## where age is divided into two groups as (5, 6.5) and (6.5 , 10) 
calc_cond_prob(df, "exam_lang_score >= 80  ~ age ",  range_list=list( list(c(5,6.5), c(6.5,10) )))
## the above is the same as below
calc_cond_prob(df, "exam_lang_score >= 80  ~ age ",  range_list=list( c(5,6.5,10) )) 
}
